/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.search.test.util.TestConfiguration;

public class ImmutableTestConfiguration
implements TestConfiguration {
    private final Set<String> tenantIds;
    private final ArrayList<Class<?>> annotatedClasses;
    private final Map<String, Object> settings;

    public ImmutableTestConfiguration(Map<String, Object> settings, Class<?>[] annotatedClasses) {
        this(settings, annotatedClasses, Collections.emptySet());
    }

    public ImmutableTestConfiguration(Map<String, Object> settings, Class<?>[] annotatedClasses, Set<String> tenantIds) {
        this.settings = settings == Collections.EMPTY_MAP ? settings : new HashMap(settings);
        this.tenantIds = tenantIds == Collections.EMPTY_SET ? tenantIds : Collections.unmodifiableSet(new HashSet<String>(tenantIds));
        this.annotatedClasses = new ArrayList(annotatedClasses.length);
        Collections.addAll(this.annotatedClasses, annotatedClasses);
    }

    @Override
    public void configure(Map<String, Object> settings) {
        settings.putAll(this.settings);
    }

    @Override
    public Set<String> multiTenantIds() {
        return this.tenantIds;
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return this.annotatedClasses.toArray(new Class[this.annotatedClasses.size()]);
    }
}

