/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.batchindexing.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import org.hibernate.CacheMode;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.PurgeAllLuceneWork;
import org.hibernate.search.backend.spi.BatchBackend;
import org.hibernate.search.batchindexing.MassIndexerProgressMonitor;
import org.hibernate.search.batchindexing.impl.BatchIndexingWorkspace;
import org.hibernate.search.batchindexing.impl.ErrorHandledRunnable;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.util.impl.Executors;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class BatchCoordinator
extends ErrorHandledRunnable {
    private static final Log log = LoggerFactory.make();
    private final Class<?>[] rootEntities;
    private final SessionFactoryImplementor sessionFactory;
    private final int typesToIndexInParallel;
    private final int documentBuilderThreads;
    private final CacheMode cacheMode;
    private final int objectLoadingBatchSize;
    private final boolean optimizeAtEnd;
    private final boolean purgeAtStart;
    private final boolean optimizeAfterPurge;
    private final CountDownLatch endAllSignal;
    private final MassIndexerProgressMonitor monitor;
    private final long objectsLimit;
    private final int idFetchSize;
    private final Integer transactionTimeout;
    private final String tenantId;
    private final List<Future<?>> indexingTasks = new ArrayList();

    public BatchCoordinator(Set<Class<?>> rootEntities, ExtendedSearchIntegrator extendedIntegrator, SessionFactoryImplementor sessionFactory, int typesToIndexInParallel, int documentBuilderThreads, CacheMode cacheMode, int objectLoadingBatchSize, long objectsLimit, boolean optimizeAtEnd, boolean purgeAtStart, boolean optimizeAfterPurge, MassIndexerProgressMonitor monitor, int idFetchSize, Integer transactionTimeout, String tenantId) {
        super(extendedIntegrator);
        this.idFetchSize = idFetchSize;
        this.transactionTimeout = transactionTimeout;
        this.tenantId = tenantId;
        this.rootEntities = rootEntities.toArray(new Class[rootEntities.size()]);
        this.sessionFactory = sessionFactory;
        this.typesToIndexInParallel = typesToIndexInParallel;
        this.documentBuilderThreads = documentBuilderThreads;
        this.cacheMode = cacheMode;
        this.objectLoadingBatchSize = objectLoadingBatchSize;
        this.optimizeAtEnd = optimizeAtEnd;
        this.purgeAtStart = purgeAtStart;
        this.optimizeAfterPurge = optimizeAfterPurge;
        this.monitor = monitor;
        this.objectsLimit = objectsLimit;
        this.endAllSignal = new CountDownLatch(rootEntities.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runWithErrorHandler() {
        BatchBackend backend = this.extendedIntegrator.makeBatchBackend(this.monitor);
        if (this.indexingTasks.size() > 0) {
            throw new AssertionFailure("BatchCoordinator instance not expected to be reused - indexingTasks should be empty");
        }
        try {
            this.beforeBatch(backend);
            this.doBatchWork(backend);
            this.afterBatch(backend);
        }
        catch (InterruptedException | ExecutionException e) {
            log.interruptedBatchIndexing();
            for (Future<?> task : this.indexingTasks) {
                if (task.isDone()) continue;
                task.cancel(true);
            }
            this.afterBatchOnInterruption(backend);
            Thread.currentThread().interrupt();
        }
        finally {
            this.monitor.indexingCompleted();
        }
    }

    private void doBatchWork(BatchBackend backend) throws InterruptedException, ExecutionException {
        ThreadPoolExecutor executor = Executors.newFixedThreadPool((int)this.typesToIndexInParallel, (String)"BatchIndexingWorkspace");
        for (Class<?> type : this.rootEntities) {
            this.indexingTasks.add(executor.submit(new BatchIndexingWorkspace(this.extendedIntegrator, this.sessionFactory, type, this.documentBuilderThreads, this.cacheMode, this.objectLoadingBatchSize, this.endAllSignal, this.monitor, backend, this.objectsLimit, this.idFetchSize, this.transactionTimeout, this.tenantId)));
        }
        executor.shutdown();
        this.endAllSignal.await();
    }

    private void afterBatch(BatchBackend backend) {
        Set targetedClasses = this.extendedIntegrator.getIndexedTypesPolymorphic((Class[])this.rootEntities);
        if (this.optimizeAtEnd) {
            backend.optimize(targetedClasses);
        }
        backend.flush(targetedClasses);
    }

    private void afterBatchOnInterruption(BatchBackend backend) {
        Set targetedClasses = this.extendedIntegrator.getIndexedTypesPolymorphic((Class[])this.rootEntities);
        backend.flush(targetedClasses);
    }

    private void beforeBatch(BatchBackend backend) {
        if (this.purgeAtStart) {
            Set targetedClasses = this.extendedIntegrator.getIndexedTypesPolymorphic((Class[])this.rootEntities);
            for (Class clazz : targetedClasses) {
                backend.doWorkInSync((LuceneWork)new PurgeAllLuceneWork(this.tenantId, clazz));
            }
            if (this.optimizeAfterPurge) {
                backend.optimize(targetedClasses);
            }
        }
    }
}

