/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.hibernate.impl;

import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.CriteriaImpl;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.hcore.util.impl.HibernateHelper;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.hibernate.search.query.hibernate.impl.LoaderHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public final class ObjectLoaderHelper {
    private static final Log log = LoggerFactory.make();

    private ObjectLoaderHelper() {
    }

    public static Object load(EntityInfo entityInfo, Session session) {
        Object maybeProxy = ObjectLoaderHelper.executeLoad(entityInfo, session);
        try {
            HibernateHelper.initialize(maybeProxy);
        }
        catch (RuntimeException e) {
            if (LoaderHelper.isObjectNotFoundException(e)) {
                log.debugf("Object found in Search index but not in database: %s with id %s", (Object)entityInfo.getClazz(), (Object)entityInfo.getId());
                session.evict(maybeProxy);
                maybeProxy = null;
            }
            throw e;
        }
        return maybeProxy;
    }

    private static Object executeLoad(EntityInfo entityInfo, Session session) {
        Object maybeProxy;
        if (ObjectLoaderHelper.areDocIdAndEntityIdIdentical(entityInfo, session)) {
            maybeProxy = session.load(entityInfo.getClazz(), entityInfo.getId());
        } else {
            CriteriaImpl criteria = new CriteriaImpl(entityInfo.getClazz().getName(), (SharedSessionContractImplementor)session);
            criteria.add((Criterion)Restrictions.eq((String)entityInfo.getIdName(), (Object)entityInfo.getId()));
            try {
                maybeProxy = criteria.uniqueResult();
            }
            catch (HibernateException e) {
                throw new SearchException("Loading entity of type " + entityInfo.getClazz().getName() + " using '" + entityInfo.getIdName() + "' as document id and '" + entityInfo.getId() + "' as value was not unique");
            }
        }
        return maybeProxy;
    }

    public static boolean areDocIdAndEntityIdIdentical(EntityInfo entityInfo, Session session) {
        String hibernateIdentifierProperty = session.getSessionFactory().getClassMetadata(entityInfo.getClazz()).getIdentifierPropertyName();
        return entityInfo.getIdName().equals(hibernateIdentifierProperty);
    }
}

