/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.hibernate.impl;

import java.util.Collections;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.hibernate.search.query.hibernate.impl.Loader;
import org.hibernate.search.stat.spi.StatisticsImplementor;

public abstract class AbstractLoader
implements Loader {
    private StatisticsImplementor statisticsImplementor;
    private boolean takeTimings;

    public void init(Session session, ExtendedSearchIntegrator extendedIntegrator) {
        this.statisticsImplementor = extendedIntegrator.getStatisticsImplementor();
        this.takeTimings = extendedIntegrator.getStatistics().isStatisticsEnabled();
    }

    @Override
    public final Object load(EntityInfo entityInfo) {
        long startTime = 0L;
        if (this.takeTimings) {
            startTime = System.nanoTime();
        }
        Object loadedObject = this.executeLoad(entityInfo);
        if (this.takeTimings) {
            this.statisticsImplementor.objectLoadExecuted(1L, System.nanoTime() - startTime);
        }
        return loadedObject;
    }

    @Override
    public Object loadWithoutTiming(EntityInfo entityInfo) {
        return this.executeLoad(entityInfo);
    }

    protected abstract Object executeLoad(EntityInfo var1);

    @Override
    public List load(List<EntityInfo> entityInfos) {
        Object entity;
        long startTime = 0L;
        if (this.takeTimings) {
            startTime = System.nanoTime();
        }
        List<Object> loadedObjects = entityInfos.isEmpty() ? Collections.EMPTY_LIST : (entityInfos.size() == 1 ? ((entity = this.executeLoad(entityInfos.get(0))) == null ? Collections.EMPTY_LIST : Collections.singletonList(entity)) : this.executeLoad(entityInfos));
        if (this.takeTimings) {
            this.statisticsImplementor.objectLoadExecuted((long)loadedObjects.size(), System.nanoTime() - startTime);
        }
        return loadedObjects;
    }

    protected abstract List executeLoad(List<EntityInfo> var1);
}

