/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.hibernate.impl;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.hibernate.search.query.engine.spi.TimeoutManager;
import org.hibernate.search.query.hibernate.impl.Loader;
import org.hibernate.search.query.hibernate.impl.ObjectInitializer;
import org.hibernate.search.query.hibernate.impl.ObjectLoaderBuilder;
import org.hibernate.transform.ResultTransformer;

public class ProjectionLoader
implements Loader {
    private Loader objectLoader;
    private boolean projectThis;
    private ResultTransformer transformer;
    private String[] aliases;
    private ObjectLoaderBuilder loaderBuilder;

    @Override
    public void init(Session session, ExtendedSearchIntegrator extendedIntegrator, ObjectInitializer objectInitializer, TimeoutManager timeoutManager) {
    }

    public void init(Session session, ExtendedSearchIntegrator extendedIntegrator, ResultTransformer transformer, ObjectLoaderBuilder loaderBuilder, String[] aliases, TimeoutManager timeoutManager, boolean projectThis) {
        this.init(session, extendedIntegrator, null, timeoutManager);
        this.transformer = transformer;
        this.aliases = aliases;
        this.loaderBuilder = loaderBuilder;
        this.projectThis = projectThis;
    }

    @Override
    public Object load(EntityInfo entityInfo) {
        if (this.projectThis) {
            Loader objectLoader = this.getObjectLoader();
            Object entityInstance = objectLoader.load(entityInfo);
            entityInfo.populateWithEntityInstance(entityInstance);
        }
        if (this.transformer != null) {
            return this.transformer.transformTuple(entityInfo.getProjection(), this.aliases);
        }
        return entityInfo.getProjection();
    }

    @Override
    public Object loadWithoutTiming(EntityInfo entityInfo) {
        throw new AssertionFailure("This method is not meant to be used on ProjectionLoader");
    }

    @Override
    public List load(List<EntityInfo> entityInfos) {
        ArrayList<Object> results = new ArrayList<Object>(entityInfos.size());
        if (entityInfos.isEmpty()) {
            return results;
        }
        if (this.projectThis) {
            Loader objectLoader = this.getObjectLoader();
            objectLoader.load(entityInfos);
            for (EntityInfo entityInfo : entityInfos) {
                Object entityInstance = objectLoader.loadWithoutTiming(entityInfo);
                entityInfo.populateWithEntityInstance(entityInstance);
            }
        }
        for (EntityInfo entityInfo : entityInfos) {
            if (this.transformer != null) {
                results.add(this.transformer.transformTuple(entityInfo.getProjection(), this.aliases));
                continue;
            }
            results.add(entityInfo.getProjection());
        }
        if (this.transformer != null) {
            return this.transformer.transformList(results);
        }
        return results;
    }

    private Loader getObjectLoader() {
        if (this.objectLoader == null) {
            this.objectLoader = this.loaderBuilder.buildLoader();
        }
        return this.objectLoader;
    }

    @Override
    public boolean isSizeSafe() {
        return this.getObjectLoader().isSizeSafe();
    }
}

