/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.impl;

import java.io.Serializable;
import java.util.Properties;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.engine.spi.SessionDelegatorBaseImpl;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.query.ParameterMetadata;
import org.hibernate.query.internal.ParameterMetadataImpl;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.FullTextSharedSessionBuilder;
import org.hibernate.search.MassIndexer;
import org.hibernate.search.SearchFactory;
import org.hibernate.search.backend.TransactionContext;
import org.hibernate.search.backend.impl.EventSourceTransactionContext;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.backend.spi.WorkType;
import org.hibernate.search.backend.spi.Worker;
import org.hibernate.search.batchindexing.impl.DefaultMassIndexerFactory;
import org.hibernate.search.batchindexing.spi.MassIndexerFactory;
import org.hibernate.search.batchindexing.spi.MassIndexerWithTenant;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.hcore.util.impl.ContextHelper;
import org.hibernate.search.hcore.util.impl.HibernateHelper;
import org.hibernate.search.impl.FullTextSharedSessionBuilderDelegator;
import org.hibernate.search.impl.SearchFactoryImpl;
import org.hibernate.search.jpa.FullTextEntityManager;
import org.hibernate.search.query.engine.spi.HSQuery;
import org.hibernate.search.query.engine.spi.QueryDescriptor;
import org.hibernate.search.query.hibernate.impl.FullTextQueryImpl;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.spi.IndexedTypeSet;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.spi.impl.IndexedTypeSets;
import org.hibernate.search.util.impl.ClassLoaderHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

final class FullTextSessionImpl
extends SessionDelegatorBaseImpl
implements FullTextSession,
SessionImplementor {
    private static final Log log = LoggerFactory.make();
    private transient ExtendedSearchIntegrator searchFactory;
    private transient SearchFactory searchFactoryAPI;
    private final TransactionContext transactionContext;

    public FullTextSessionImpl(Session session) {
        super((SessionImplementor)session);
        if (session == null) {
            throw log.getNullSessionPassedToFullTextSessionCreationException();
        }
        this.transactionContext = new EventSourceTransactionContext((EventSource)session);
    }

    @Override
    public FullTextQuery createFullTextQuery(Query luceneQuery, Class<?> ... entities) {
        HSQuery hsQuery = this.getSearchIntegrator().createHSQuery(luceneQuery, (Class[])entities);
        return this.createFullTextQuery(hsQuery, new Class[0]);
    }

    @Override
    public FullTextQuery createFullTextQuery(QueryDescriptor queryDescriptor, Class<?> ... entities) {
        HSQuery hsQuery = queryDescriptor.createHSQuery((SearchIntegrator)this.getSearchIntegrator()).targetedEntities(IndexedTypeSets.fromClasses((Class[])entities));
        return this.createFullTextQuery(hsQuery, new Class[0]);
    }

    private FullTextQuery createFullTextQuery(HSQuery hsQuery, Class<?> ... entities) {
        return new FullTextQueryImpl(hsQuery, this.delegate, (ParameterMetadata)new ParameterMetadataImpl(null, null));
    }

    @Override
    public <T> void purgeAll(Class<T> entityType) {
        this.purge(entityType, null);
    }

    @Override
    public void flushToIndexes() {
        ExtendedSearchIntegrator extendedIntegrator = this.getSearchIntegrator();
        extendedIntegrator.getWorker().flushWorks(this.transactionContext);
    }

    @Override
    public <T> void purge(Class<T> entityType, Serializable id) {
        if (entityType == null) {
            return;
        }
        ExtendedSearchIntegrator searchIntegrator = this.getSearchIntegrator();
        IndexedTypeIdentifier typeIdentifier = searchIntegrator.getIndexBindings().keyFromPojoType(entityType);
        IndexedTypeSet targetedClasses = this.getSearchIntegrator().getIndexedTypesPolymorphic(typeIdentifier.asTypeSet());
        if (targetedClasses.isEmpty()) {
            String msg = entityType.getName() + " is not an indexed entity or a subclass of an indexed entity";
            throw new IllegalArgumentException(msg);
        }
        for (IndexedTypeIdentifier type : targetedClasses) {
            if (id == null) {
                this.createAndPerformWork(type, null, WorkType.PURGE_ALL);
                continue;
            }
            this.createAndPerformWork(type, id, WorkType.PURGE);
        }
    }

    private void createAndPerformWork(IndexedTypeIdentifier type, Serializable id, WorkType workType) {
        Work work = new Work(this.delegate.getTenantIdentifier(), type, id, workType);
        this.getSearchIntegrator().getWorker().performWork(work, this.transactionContext);
    }

    @Override
    public <T> void index(T entity) {
        if (entity == null) {
            throw new IllegalArgumentException("Entity to index should not be null");
        }
        Class<T> clazz = HibernateHelper.getClass(entity);
        ExtendedSearchIntegrator extendedIntegrator = this.getSearchIntegrator();
        if (extendedIntegrator.getIndexBinding(clazz) == null) {
            String msg = "Entity to index is not an @Indexed entity: " + entity.getClass().getName();
            throw new IllegalArgumentException(msg);
        }
        Serializable id = this.delegate.getIdentifier(entity);
        String tenantIdentifier = this.getTenantIdentifier();
        Work work = new Work(tenantIdentifier, entity, id, WorkType.INDEX);
        Worker worker = extendedIntegrator.getWorker();
        worker.performWork(work, this.transactionContext);
    }

    @Override
    public MassIndexer createIndexer(Class<?> ... types) {
        MassIndexerFactory massIndexerFactory = this.createMassIndexerFactory();
        MassIndexer massIndexer = massIndexerFactory.createMassIndexer((SearchIntegrator)this.getSearchIntegrator(), this.getFactory(), types);
        if (massIndexer instanceof MassIndexerWithTenant) {
            ((MassIndexerWithTenant)massIndexer).tenantIdentifier(this.getTenantIdentifier());
        }
        return massIndexer;
    }

    @Override
    public SearchFactory getSearchFactory() {
        if (this.searchFactoryAPI == null) {
            this.searchFactoryAPI = new SearchFactoryImpl(this.getSearchIntegrator());
        }
        return this.searchFactoryAPI;
    }

    private ExtendedSearchIntegrator getSearchIntegrator() {
        if (this.searchFactory == null) {
            this.searchFactory = ContextHelper.getSearchIntegrator((Session)this.delegate);
        }
        return this.searchFactory;
    }

    @Override
    public FullTextSharedSessionBuilder sessionWithOptions() {
        return new FullTextSharedSessionBuilderDelegator(super.sessionWithOptions());
    }

    private MassIndexerFactory createMassIndexerFactory() {
        MassIndexerFactory factory;
        Properties properties = this.getSearchIntegrator().getConfigurationProperties();
        String factoryClassName = properties.getProperty("hibernate.search.massindexer.factoryclass");
        if (factoryClassName != null) {
            ExtendedSearchIntegrator extendedIntegrator = this.getSearchIntegrator();
            ServiceManager serviceManager = extendedIntegrator.getServiceManager();
            factory = (MassIndexerFactory)ClassLoaderHelper.instanceFromName(MassIndexerFactory.class, (String)factoryClassName, (String)"Mass indexer factory", (ServiceManager)serviceManager);
        } else {
            factory = new DefaultMassIndexerFactory();
        }
        factory.initialize(properties);
        return factory;
    }

    public <T> T unwrap(Class<T> type) {
        if (type.equals(FullTextEntityManager.class)) {
            return (T)this;
        }
        if (type.equals(FullTextSession.class)) {
            return (T)this;
        }
        return (T)super.unwrap(type);
    }
}

