/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.hcore.impl;

import java.util.concurrent.CompletableFuture;
import org.hibernate.SessionFactory;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.jndi.spi.JndiService;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.search.cfg.impl.SearchConfigurationFromHibernateCore;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.Version;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.event.impl.FullTextIndexEventListener;
import org.hibernate.search.hcore.impl.DefaultHibernateSessionFactoryService;
import org.hibernate.search.hcore.impl.JMXHook;
import org.hibernate.search.hcore.impl.SearchFactoryReference;
import org.hibernate.search.hcore.spi.BeanResolver;
import org.hibernate.search.hcore.spi.EnvironmentSynchronizer;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.spi.SearchIntegratorBuilder;

public class HibernateSearchSessionFactoryObserver
implements SessionFactoryObserver {
    private final ConfigurationService configurationService;
    private final JndiService namingService;
    private final ClassLoaderService classLoaderService;
    private final EnvironmentSynchronizer environmentSynchronizer;
    private final BeanResolver beanResolver;
    private final FullTextIndexEventListener listener;
    private final Metadata metadata;
    private final CompletableFuture<ExtendedSearchIntegrator> extendedSearchIntegratorFuture = new CompletableFuture();
    private JMXHook jmx;

    public HibernateSearchSessionFactoryObserver(Metadata metadata, ConfigurationService configurationService, FullTextIndexEventListener listener, ClassLoaderService classLoaderService, EnvironmentSynchronizer environmentSynchronizer, BeanResolver beanResolver, JndiService namingService) {
        this.metadata = metadata;
        this.configurationService = configurationService;
        this.listener = listener;
        this.classLoaderService = classLoaderService;
        this.environmentSynchronizer = environmentSynchronizer;
        this.beanResolver = beanResolver;
        this.namingService = namingService;
    }

    public void sessionFactoryCreated(SessionFactory factory) {
        boolean failedBootScheduling = true;
        try {
            this.listener.initialize(this.extendedSearchIntegratorFuture);
            if (this.environmentSynchronizer != null) {
                this.environmentSynchronizer.whenEnvironmentReady(() -> this.boot(factory));
            } else {
                this.boot(factory);
            }
            failedBootScheduling = false;
        }
        finally {
            if (failedBootScheduling) {
                this.cancelBoot();
            }
        }
    }

    private synchronized void boot(SessionFactory factory) {
        if (this.extendedSearchIntegratorFuture.isDone()) {
            return;
        }
        boolean failedBoot = true;
        try {
            DefaultHibernateSessionFactoryService sessionService = new DefaultHibernateSessionFactoryService(factory);
            SearchIntegrator searchIntegrator = new SearchIntegratorBuilder().configuration((SearchConfiguration)new SearchConfigurationFromHibernateCore(this.metadata, this.configurationService, this.classLoaderService, this.beanResolver, sessionService, this.namingService)).buildSearchIntegrator();
            ExtendedSearchIntegrator extendedIntegrator = (ExtendedSearchIntegrator)searchIntegrator.unwrap(ExtendedSearchIntegrator.class);
            this.jmx = new JMXHook(this.configurationService);
            this.jmx.registerIfEnabled(extendedIntegrator, factory);
            this.extendedSearchIntegratorFuture.complete(extendedIntegrator);
            SessionFactoryImplementor factoryImplementor = (SessionFactoryImplementor)factory;
            ((SearchFactoryReference)factoryImplementor.getServiceRegistry().getService(SearchFactoryReference.class)).initialize(extendedIntegrator);
            failedBoot = false;
        }
        catch (RuntimeException e) {
            this.extendedSearchIntegratorFuture.completeExceptionally(e);
            throw e;
        }
        finally {
            if (failedBoot) {
                factory.close();
            }
        }
    }

    public synchronized void sessionFactoryClosing(SessionFactory factory) {
        this.cancelBoot();
    }

    private synchronized void cancelBoot() {
        this.extendedSearchIntegratorFuture.cancel(false);
    }

    public void sessionFactoryClosed(SessionFactory factory) {
        this.extendedSearchIntegratorFuture.thenAccept(this::cleanup);
    }

    private synchronized void cleanup(ExtendedSearchIntegrator extendedIntegrator) {
        if (extendedIntegrator != null) {
            extendedIntegrator.close();
        }
        this.jmx.unRegisterIfRegistered();
    }

    static {
        Version.touch();
    }
}

