/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test;

import java.io.File;
import java.io.InputStream;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.KeywordAnalyzer;
import org.apache.lucene.analysis.SimpleAnalyzer;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Version;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.hibernate.event.PostInsertEventListener;
import org.hibernate.impl.SessionFactoryImpl;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.SearchFactory;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.event.FullTextIndexEventListener;
import org.hibernate.search.store.RAMDirectoryProvider;
import org.hibernate.search.test.TestCase;
import org.hibernate.search.util.LoggerFactory;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SearchTestCase
extends TestCase {
    private static final Logger log = LoggerFactory.make();
    public static Analyzer standardAnalyzer = new StandardAnalyzer(SearchTestCase.getTargetLuceneVersion());
    public static Analyzer stopAnalyzer = new StopAnalyzer(SearchTestCase.getTargetLuceneVersion());
    public static Analyzer simpleAnalyzer = new SimpleAnalyzer();
    public static Analyzer keywordAnalyzer = new KeywordAnalyzer();
    private static File indexDir;
    private SearchFactory searchFactory;

    @Override
    protected void setUp() throws Exception {
        this.buildSessionFactory(this.getMappings(), this.getAnnotatedPackages(), this.getXmlFiles());
        this.ensureIndexesAreEmpty();
    }

    protected void tearDown() throws Exception {
        SchemaExport export = new SchemaExport(cfg);
        export.drop(false, true);
        this.searchFactory = null;
    }

    protected Directory getDirectory(Class<?> clazz) {
        return this.getLuceneEventListener().getSearchFactoryImplementor().getDirectoryProviders(clazz)[0].getDirectory();
    }

    private FullTextIndexEventListener getLuceneEventListener() {
        PostInsertEventListener[] listeners = ((SessionFactoryImpl)this.getSessions()).getEventListeners().getPostInsertEventListeners();
        FullTextIndexEventListener listener = null;
        for (PostInsertEventListener candidate : listeners) {
            if (!(candidate instanceof FullTextIndexEventListener)) continue;
            listener = (FullTextIndexEventListener)candidate;
            break;
        }
        if (listener == null) {
            throw new HibernateException("Lucene event listener not initialized");
        }
        return listener;
    }

    protected void ensureIndexesAreEmpty() {
        if ("jms".equals(SearchTestCase.getCfg().getProperty("hibernate.search.worker.backend"))) {
            log.debug("JMS based test. Skipping index emptying");
            return;
        }
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        for (Class<?> clazz : this.getMappings()) {
            if (clazz.getAnnotation(Indexed.class) == null) continue;
            s.purgeAll(clazz);
        }
        tx.commit();
        s.close();
    }

    protected SearchFactory getSearchFactory() {
        if (this.searchFactory == null) {
            Session session = this.openSession();
            FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
            this.searchFactory = fullTextSession.getSearchFactory();
            fullTextSession.close();
        }
        return this.searchFactory;
    }

    @Override
    protected void configure(Configuration cfg) {
        cfg.setProperty("hibernate.search.default.directory_provider", RAMDirectoryProvider.class.getName());
        cfg.setProperty("hibernate.search.default.indexBase", indexDir.getAbsolutePath());
        cfg.setProperty("hibernate.search.analyzer", StopAnalyzer.class.getName());
        cfg.setProperty("hibernate.search.default.transaction.merge_factor", "100");
        cfg.setProperty("hibernate.search.default.batch.max_buffered_docs", "1000");
    }

    protected File getBaseIndexDir() {
        return indexDir;
    }

    protected void buildSessionFactory(Class<?>[] classes, String[] packages, String[] xmlFiles) throws Exception {
        if (this.getSessions() != null) {
            this.getSessions().close();
        }
        try {
            SearchTestCase.setCfg((Configuration)new AnnotationConfiguration());
            this.configure(cfg);
            if (this.recreateSchema()) {
                cfg.setProperty("hibernate.hbm2ddl.auto", "create-drop");
            }
            for (String aPackage : packages) {
                ((AnnotationConfiguration)SearchTestCase.getCfg()).addPackage(aPackage);
            }
            for (Class<?> aClass : classes) {
                ((AnnotationConfiguration)SearchTestCase.getCfg()).addAnnotatedClass((Class)aClass);
            }
            for (String xmlFile : xmlFiles) {
                InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(xmlFile);
                SearchTestCase.getCfg().addInputStream(is);
            }
            this.setDialect(Dialect.getDialect());
            this.setSessions(SearchTestCase.getCfg().buildSessionFactory());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    protected abstract Class<?>[] getMappings();

    protected String[] getAnnotatedPackages() {
        return new String[0];
    }

    protected static File getIndexDir() {
        return indexDir;
    }

    public static Version getTargetLuceneVersion() {
        return Version.LUCENE_29;
    }

    static {
        String buildDir = System.getProperty("build.dir");
        if (buildDir == null) {
            buildDir = ".";
        }
        File current = new File(buildDir);
        indexDir = new File(current, "indextemp");
        log.debug("Using {} as index directory.", (Object)indexDir.getAbsolutePath());
    }
}

