/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.util;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import junit.framework.Assert;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.hibernate.search.util.LoggerFactory;
import org.slf4j.Logger;

public class AnalyzerUtils {
    public static final Logger log = LoggerFactory.make();

    public static Token[] tokensFromAnalysis(Analyzer analyzer, String field, String text) throws IOException {
        Token token;
        TokenStream stream = analyzer.tokenStream(field, (Reader)new StringReader(text));
        ArrayList<Token> tokenList = new ArrayList<Token>();
        Token reusableToken = new Token();
        while ((token = stream.next(reusableToken)) != null) {
            tokenList.add((Token)token.clone());
        }
        return tokenList.toArray(new Token[tokenList.size()]);
    }

    public static void displayTokens(Analyzer analyzer, String field, String text) throws IOException {
        Token[] tokens;
        for (Token token : tokens = AnalyzerUtils.tokensFromAnalysis(analyzer, field, text)) {
            log.debug("[" + AnalyzerUtils.getTermText(token) + "] ");
        }
    }

    public static void displayTokensWithPositions(Analyzer analyzer, String field, String text) throws IOException {
        Token[] tokens = AnalyzerUtils.tokensFromAnalysis(analyzer, field, text);
        int position = 0;
        for (Token token : tokens) {
            int increment = token.getPositionIncrement();
            if (increment > 0) {
                System.out.println();
                System.out.print((position += increment) + ": ");
            }
            log.debug("[" + AnalyzerUtils.getTermText(token) + "] ");
        }
    }

    public static void displayTokensWithFullDetails(Analyzer analyzer, String field, String text) throws IOException {
        Token[] tokens = AnalyzerUtils.tokensFromAnalysis(analyzer, field, text);
        StringBuilder builder = new StringBuilder();
        int position = 0;
        for (Token token : tokens) {
            int increment = token.getPositionIncrement();
            if (increment > 0) {
                builder.append("\n").append(position += increment).append(": ");
            }
            builder.append("[").append(AnalyzerUtils.getTermText(token)).append(":").append(token.startOffset()).append("->").append(token.endOffset()).append(":").append(token.type()).append("] ");
            log.debug(builder.toString());
        }
    }

    public static void assertTokensEqual(Token[] tokens, String[] strings) {
        Assert.assertEquals((int)strings.length, (int)tokens.length);
        for (int i = 0; i < tokens.length; ++i) {
            Assert.assertEquals((String)("index " + i), (String)strings[i], (String)AnalyzerUtils.getTermText(tokens[i]));
        }
    }

    public static String getTermText(Token token) {
        return new String(token.termBuffer(), 0, token.termLength());
    }
}

