/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test;

import java.io.InputStream;
import org.apache.lucene.analysis.StopAnalyzer;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.hibernate.event.FlushEventListener;
import org.hibernate.event.def.DefaultFlushEventListener;
import org.hibernate.search.event.FullTextIndexEventListener;
import org.hibernate.search.store.RAMDirectoryProvider;

public abstract class TestCase
extends junit.framework.TestCase {
    protected static SessionFactory sessions;
    protected static Configuration cfg;
    protected static Dialect dialect;
    protected static Class lastTestClass;
    protected Session session;

    public TestCase() {
    }

    public TestCase(String x) {
        super(x);
    }

    protected void buildSessionFactory(String[] xmlFiles) throws Exception {
        if (this.getSessions() != null) {
            this.getSessions().close();
        }
        try {
            TestCase.setCfg(new Configuration());
            this.configure(cfg);
            if (this.recreateSchema()) {
                cfg.setProperty("hibernate.hbm2ddl.auto", "create-drop");
            }
            for (String xmlFile : xmlFiles) {
                InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(xmlFile);
                TestCase.getCfg().addInputStream(is);
            }
            this.setDialect(Dialect.getDialect());
            this.setSessions(TestCase.getCfg().buildSessionFactory());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    protected void setUp() throws Exception {
        if (this.getSessions() == null || this.getSessions().isClosed() || lastTestClass != ((Object)((Object)this)).getClass()) {
            this.buildSessionFactory(this.getXmlFiles());
            lastTestClass = ((Object)((Object)this)).getClass();
        }
    }

    protected void runTest() throws Throwable {
        try {
            super.runTest();
            if (this.session != null && this.session.isOpen()) {
                if (this.session.isConnected()) {
                    this.session.connection().rollback();
                }
                this.session.close();
                this.session = null;
                TestCase.fail((String)"unclosed session");
            } else {
                this.session = null;
            }
        }
        catch (Throwable e) {
            try {
                if (this.session != null && this.session.isOpen()) {
                    if (this.session.isConnected()) {
                        this.session.connection().rollback();
                    }
                    this.session.close();
                }
            }
            catch (Exception ignore) {
                // empty catch block
            }
            try {
                if (sessions != null) {
                    sessions.close();
                    sessions = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    public Session openSession() throws HibernateException {
        this.session = this.getSessions().openSession();
        return this.session;
    }

    public Session openSession(Interceptor interceptor) throws HibernateException {
        this.session = this.getSessions().openSession(interceptor);
        return this.session;
    }

    protected String[] getXmlFiles() {
        return new String[0];
    }

    protected void setSessions(SessionFactory sessions) {
        TestCase.sessions = sessions;
    }

    protected SessionFactory getSessions() {
        return sessions;
    }

    protected void setDialect(Dialect dialect) {
        TestCase.dialect = dialect;
    }

    protected Dialect getDialect() {
        return dialect;
    }

    protected static void setCfg(Configuration cfg) {
        TestCase.cfg = cfg;
    }

    protected static Configuration getCfg() {
        return cfg;
    }

    protected void configure(Configuration cfg) {
        cfg.setListener("post-update", "org.hibernate.search.event.FullTextIndexEventListener");
        cfg.setListener("post-insert", "org.hibernate.search.event.FullTextIndexEventListener");
        cfg.setListener("post-delete", "org.hibernate.search.event.FullTextIndexEventListener");
        cfg.setListener("post-collection-recreate", "org.hibernate.search.event.FullTextIndexEventListener");
        cfg.setListener("post-collection-remove", "org.hibernate.search.event.FullTextIndexEventListener");
        cfg.setListener("post-collection-update", "org.hibernate.search.event.FullTextIndexEventListener");
        cfg.setListeners("flush", (Object[])new FlushEventListener[]{new DefaultFlushEventListener(), new FullTextIndexEventListener()});
        cfg.setProperty("hibernate.search.default.directory_provider", RAMDirectoryProvider.class.getName());
        cfg.setProperty("hibernate.search.analyzer", StopAnalyzer.class.getName());
    }

    protected boolean recreateSchema() {
        return true;
    }
}

