/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.util;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.fest.assertions.Assertions;
import org.fest.assertions.Formatting;
import org.fest.assertions.GenericAssert;
import org.fest.assertions.ObjectAssert;
import org.fest.assertions.ThrowableAssert;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class FutureAssert<T>
extends GenericAssert<FutureAssert<T>, Future<T>> {
    public static <T> FutureAssert<T> assertThat(Future<T> future) {
        return new FutureAssert<T>(future);
    }

    protected FutureAssert(Future<T> actual) {
        super(FutureAssert.class, actual);
    }

    public FutureAssert<T> isPending() {
        try {
            T result = this.getNow();
            this.failIfCustomMessageIsSet();
            this.fail(Formatting.format((String)"future <%s> should be pending, but instead it succeeded with result <%s>", (Object[])new Object[]{this.actual, result}));
        }
        catch (TimeoutException result) {
        }
        catch (CancellationException e) {
            this.failIfCustomMessageIsSet(e);
            this.fail(Formatting.format((String)"future <%s> should be pending, but instead it's been cancelled", (Object[])new Object[]{this.actual}), e);
        }
        catch (ExecutionException e) {
            this.failIfCustomMessageIsSet(e);
            this.fail(Formatting.format((String)"future <%s> should be pending, but instead it failed with exception: %s", (Object[])new Object[]{this.actual, e}), e);
        }
        return this;
    }

    public FutureAssert<T> isSuccessful() {
        return this.isSuccessful(value -> {});
    }

    public FutureAssert<T> isSuccessful(T expectedValue) {
        return this.isSuccessful(value -> {
            ObjectAssert cfr_ignored_0 = (ObjectAssert)Assertions.assertThat((Object)expectedValue).isEqualTo(expectedValue);
        });
    }

    public FutureAssert<T> isSuccessful(Consumer<T> valueAssertion) {
        try {
            T result = this.getNow();
            try {
                valueAssertion.accept(result);
            }
            catch (AssertionError e2) {
                this.failIfCustomMessageIsSet((Throwable)((Object)e2));
                this.fail(Formatting.format((String)"future <%s> succeeded as expected, but the result is wrong: %s", (Object[])new Object[]{this.actual, e2}), (Throwable)((Object)e2));
            }
        }
        catch (TimeoutException e) {
            this.failIfCustomMessageIsSet();
            this.fail(Formatting.format((String)"future <%s> should have succeeded, but instead it's still pending", (Object[])new Object[]{this.actual}));
        }
        catch (CancellationException e) {
            this.failIfCustomMessageIsSet(e);
            this.fail(Formatting.format((String)"future <%s> should have succeeded, but instead it's been cancelled", (Object[])new Object[]{this.actual}), e);
        }
        catch (ExecutionException e) {
            this.failIfCustomMessageIsSet(e);
            this.fail(Formatting.format((String)"future <%s> should have succeeded, but instead it failed with exception: %s", (Object[])new Object[]{this.actual, e}), e);
        }
        return this;
    }

    public FutureAssert<T> isFailed() {
        return this.isFailed((Throwable throwable) -> {});
    }

    public FutureAssert<T> isFailed(Throwable expectedThrowable) {
        return this.isFailed((Throwable throwable) -> {
            ThrowableAssert cfr_ignored_0 = (ThrowableAssert)Assertions.assertThat((Throwable)throwable).isEqualTo((Object)expectedThrowable);
        });
    }

    public FutureAssert<T> isFailed(Matcher<? super Throwable> exceptionMatcher) {
        return this.isFailed((Throwable throwable) -> Assert.assertThat((Object)throwable, (Matcher)exceptionMatcher));
    }

    public FutureAssert<T> isFailed(Consumer<Throwable> exceptionAssertion) {
        try {
            T result = this.getNow();
            this.failIfCustomMessageIsSet();
            this.fail(Formatting.format((String)"future <%s> should have failed, but instead it succeeded with result <%s>", (Object[])new Object[]{this.actual, result}));
        }
        catch (TimeoutException e) {
            this.failIfCustomMessageIsSet(e);
            this.fail(Formatting.format((String)"future <%s> should have failed, but instead it's still pending", (Object[])new Object[]{this.actual}), e);
        }
        catch (CancellationException e) {
            this.failIfCustomMessageIsSet(e);
            this.fail(Formatting.format((String)"future <%s> should have failed, but instead it's been cancelled", (Object[])new Object[]{this.actual}), e);
        }
        catch (ExecutionException e) {
            try {
                exceptionAssertion.accept(e.getCause());
            }
            catch (AssertionError e2) {
                this.failIfCustomMessageIsSet((Throwable)((Object)e2));
                this.fail(Formatting.format((String)"future <%s> failed as expected, but the exception is wrong: %s", (Object[])new Object[]{this.actual, e2}), (Throwable)((Object)e2));
            }
        }
        return this;
    }

    private T getNow() throws TimeoutException, CancellationException, ExecutionException {
        try {
            return (T)((Future)this.actual).get(0L, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Interrupted while getting a future value with a 0 timeout (?)", e);
        }
        catch (CancellationException | TimeoutException e) {
            throw e;
        }
        catch (ExecutionException e) {
            for (Throwable t = e; t != null; t = t.getCause()) {
                if (!(t instanceof AssertionError)) continue;
                this.fail(Formatting.format((String)"future <%s> failed because of a failing assertion: %s", (Object[])new Object[]{this.actual, e.getCause()}), e.getCause());
            }
            throw e;
        }
    }
}

