/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.impl.lucene.PerDPQueueProcessor;
import org.hibernate.search.backend.impl.lucene.works.LuceneWorkVisitor;
import org.hibernate.search.store.DirectoryProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class QueueProcessors {
    private final Map<DirectoryProvider, LuceneWorkVisitor> visitorsMap;
    private final Map<DirectoryProvider, PerDPQueueProcessor> dpProcessors = new HashMap<DirectoryProvider, PerDPQueueProcessor>();

    QueueProcessors(Map<DirectoryProvider, LuceneWorkVisitor> visitorsMap) {
        this.visitorsMap = visitorsMap;
    }

    void addWorkToDpProcessor(DirectoryProvider dp, LuceneWork work) {
        if (!this.dpProcessors.containsKey(dp)) {
            this.dpProcessors.put(dp, new PerDPQueueProcessor(this.visitorsMap.get(dp)));
        }
        PerDPQueueProcessor processor = this.dpProcessors.get(dp);
        processor.addWork(work);
    }

    Collection<PerDPQueueProcessor> getQueueProcessors() {
        return this.dpProcessors.values();
    }
}

