/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene;

import java.util.List;
import java.util.Map;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.impl.lucene.DpSelectionVisitor;
import org.hibernate.search.backend.impl.lucene.PerDPQueueProcessor;
import org.hibernate.search.backend.impl.lucene.QueueProcessors;
import org.hibernate.search.backend.impl.lucene.works.LuceneWorkVisitor;
import org.hibernate.search.engine.DocumentBuilder;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.store.IndexShardingStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LuceneBackendQueueProcessor
implements Runnable {
    private final List<LuceneWork> queue;
    private final SearchFactoryImplementor searchFactoryImplementor;
    private final Map<DirectoryProvider, LuceneWorkVisitor> visitorsMap;
    private static final DpSelectionVisitor providerSelectionVisitor = new DpSelectionVisitor();

    LuceneBackendQueueProcessor(List<LuceneWork> queue, SearchFactoryImplementor searchFactoryImplementor, Map<DirectoryProvider, LuceneWorkVisitor> visitorsMap) {
        this.queue = queue;
        this.searchFactoryImplementor = searchFactoryImplementor;
        this.visitorsMap = visitorsMap;
    }

    @Override
    public void run() {
        QueueProcessors processors = new QueueProcessors(this.visitorsMap);
        for (LuceneWork work : this.queue) {
            Class entityType = work.getEntityClass();
            DocumentBuilder documentBuilder = this.searchFactoryImplementor.getDocumentBuilder(entityType);
            IndexShardingStrategy shardingStrategy = documentBuilder.getDirectoryProviderSelectionStrategy();
            work.getWorkDelegate(providerSelectionVisitor).addAsPayLoadsToQueue(work, shardingStrategy, processors);
        }
        for (PerDPQueueProcessor processor : processors.getQueueProcessors()) {
            processor.performWorks();
        }
    }
}

