/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene.works;

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.Similarity;
import org.hibernate.search.SearchException;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.Workspace;
import org.hibernate.search.backend.impl.lucene.IndexInteractionType;
import org.hibernate.search.backend.impl.lucene.works.LuceneWorkDelegate;
import org.hibernate.search.engine.DocumentBuilder;
import org.hibernate.search.util.LoggerFactory;
import org.slf4j.Logger;

class AddWorkDelegate
implements LuceneWorkDelegate {
    private static final Logger log = LoggerFactory.make();
    private final Workspace workspace;

    AddWorkDelegate(Workspace workspace) {
        this.workspace = workspace;
    }

    public IndexInteractionType getIndexInteractionType() {
        return IndexInteractionType.NEEDS_INDEXWRITER;
    }

    public void performWork(LuceneWork work, IndexWriter writer) {
        DocumentBuilder documentBuilder = this.workspace.getDocumentBuilder(work.getEntityClass());
        Analyzer analyzer = documentBuilder.getAnalyzer();
        Similarity similarity = documentBuilder.getSimilarity();
        if (log.isTraceEnabled()) {
            log.trace("add to Lucene index: {}#{}:{}", new Object[]{work.getEntityClass(), work.getId(), work.getDocument()});
        }
        try {
            writer.setSimilarity(similarity);
            writer.addDocument(work.getDocument(), analyzer);
            this.workspace.incrementModificationCounter(1);
        }
        catch (IOException e) {
            throw new SearchException("Unable to add to Lucene index: " + work.getEntityClass() + "#" + work.getId(), e);
        }
    }

    public void performWork(LuceneWork work, IndexReader reader) {
        throw new UnsupportedOperationException();
    }
}

