/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene.works;

import org.hibernate.search.backend.AddLuceneWork;
import org.hibernate.search.backend.DeleteLuceneWork;
import org.hibernate.search.backend.OptimizeLuceneWork;
import org.hibernate.search.backend.PurgeAllLuceneWork;
import org.hibernate.search.backend.WorkVisitor;
import org.hibernate.search.backend.Workspace;
import org.hibernate.search.backend.impl.lucene.works.AddWorkDelegate;
import org.hibernate.search.backend.impl.lucene.works.DeleteExtWorkDelegate;
import org.hibernate.search.backend.impl.lucene.works.DeleteWorkDelegate;
import org.hibernate.search.backend.impl.lucene.works.LuceneWorkDelegate;
import org.hibernate.search.backend.impl.lucene.works.OptimizeWorkDelegate;
import org.hibernate.search.backend.impl.lucene.works.PurgeAllWorkDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneWorkVisitor
implements WorkVisitor<LuceneWorkDelegate> {
    private final AddWorkDelegate addDelegate;
    private final DeleteWorkDelegate deleteDelegate;
    private final OptimizeWorkDelegate optimizeDelegate;
    private final PurgeAllWorkDelegate purgeAllDelegate;
    private final Workspace linkedWorkspace;

    public LuceneWorkVisitor(Workspace workspace) {
        this.deleteDelegate = workspace.getEntitiesInDirectory().size() == 1 ? new DeleteExtWorkDelegate(workspace) : new DeleteWorkDelegate(workspace);
        this.purgeAllDelegate = new PurgeAllWorkDelegate();
        this.addDelegate = new AddWorkDelegate(workspace);
        this.optimizeDelegate = new OptimizeWorkDelegate(workspace);
        this.linkedWorkspace = workspace;
    }

    @Override
    public LuceneWorkDelegate getDelegate(AddLuceneWork addLuceneWork) {
        return this.addDelegate;
    }

    @Override
    public LuceneWorkDelegate getDelegate(DeleteLuceneWork deleteLuceneWork) {
        return this.deleteDelegate;
    }

    @Override
    public LuceneWorkDelegate getDelegate(OptimizeLuceneWork optimizeLuceneWork) {
        return this.optimizeDelegate;
    }

    @Override
    public LuceneWorkDelegate getDelegate(PurgeAllLuceneWork purgeAllLuceneWork) {
        return this.purgeAllDelegate;
    }

    public Workspace getWorkspace() {
        return this.linkedWorkspace;
    }
}

