/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.search.engine.EntityInfo;
import org.hibernate.search.engine.Loader;
import org.hibernate.search.engine.MultiClassesQueryLoader;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.transform.ResultTransformer;

public class ProjectionLoader
implements Loader {
    private SearchFactoryImplementor searchFactoryImplementor;
    private Session session;
    private Loader objectLoader;
    private Boolean projectThis;
    private ResultTransformer transformer;
    private String[] aliases;
    private Class[] entityTypes;

    public void init(Session session, SearchFactoryImplementor searchFactoryImplementor) {
        this.session = session;
        this.searchFactoryImplementor = searchFactoryImplementor;
    }

    public void init(Session session, SearchFactoryImplementor searchFactoryImplementor, ResultTransformer transformer, String[] aliases) {
        this.init(session, searchFactoryImplementor);
        this.transformer = transformer;
        this.aliases = aliases;
    }

    public void setEntityTypes(Class[] entityTypes) {
        this.entityTypes = entityTypes;
    }

    public Object load(EntityInfo entityInfo) {
        this.initThisProjectionFlag(entityInfo);
        if (this.projectThis.booleanValue()) {
            for (int index : entityInfo.indexesOfThis) {
                entityInfo.projection[index] = this.objectLoader.load(entityInfo);
            }
        }
        if (this.transformer != null) {
            return this.transformer.transformTuple(entityInfo.projection, this.aliases);
        }
        return entityInfo.projection;
    }

    private void initThisProjectionFlag(EntityInfo entityInfo) {
        if (this.projectThis == null) {
            this.projectThis = entityInfo.indexesOfThis.size() != 0;
            if (this.projectThis.booleanValue()) {
                MultiClassesQueryLoader loader = new MultiClassesQueryLoader();
                loader.init(this.session, this.searchFactoryImplementor);
                loader.setEntityTypes(this.entityTypes);
                this.objectLoader = loader;
            }
        }
    }

    public List load(EntityInfo ... entityInfos) {
        ArrayList<Object> results = new ArrayList<Object>(entityInfos.length);
        if (entityInfos.length == 0) {
            return results;
        }
        this.initThisProjectionFlag(entityInfos[0]);
        if (this.projectThis.booleanValue()) {
            this.objectLoader.load(entityInfos);
            for (EntityInfo entityInfo : entityInfos) {
                for (int index : entityInfo.indexesOfThis) {
                    entityInfo.projection[index] = this.objectLoader.load(entityInfo);
                }
            }
        }
        for (EntityInfo entityInfo : entityInfos) {
            if (this.transformer != null) {
                results.add(this.transformer.transformTuple(entityInfo.projection, this.aliases));
                continue;
            }
            results.add(entityInfo.projection);
        }
        return results;
    }
}

