/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.search.filter.AndDocIdSet;

public class ChainedFilter
extends Filter {
    private static final long serialVersionUID = -6153052295766531920L;
    private final List<Filter> chainedFilters = new ArrayList<Filter>();

    public void addFilter(Filter filter) {
        this.chainedFilters.add(filter);
    }

    public BitSet bits(IndexReader reader) throws IOException {
        throw new UnsupportedOperationException();
    }

    public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
        int size = this.chainedFilters.size();
        if (size == 0) {
            throw new AssertionFailure("Chainedfilter has no filters to chain for");
        }
        if (size == 1) {
            return this.chainedFilters.get(0).getDocIdSet(reader);
        }
        ArrayList<DocIdSet> subSets = new ArrayList<DocIdSet>(size);
        for (Filter f : this.chainedFilters) {
            subSets.add(f.getDocIdSet(reader));
        }
        return new AndDocIdSet(subSets, reader.maxDoc());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ChainedFilter [");
        for (Filter filter : this.chainedFilters) {
            sb.append("\n  ").append(filter.toString());
        }
        return sb.append("\n]").toString();
    }
}

