/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query;

import java.io.IOException;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.hibernate.search.SearchException;

public class QueryHits {
    private static final int DEFAULT_TOP_DOC_RETRIEVAL_SIZE = 100;
    public final Query preparedQuery;
    public final Searcher searcher;
    public final Filter filter;
    public final Sort sort;
    public final int totalHits;
    public TopDocs topDocs;

    public QueryHits(Searcher searcher, Query preparedQuery, Filter filter, Sort sort) throws IOException {
        this.preparedQuery = preparedQuery;
        this.searcher = searcher;
        this.filter = filter;
        this.sort = sort;
        this.updateTopDocs(100);
        this.totalHits = this.topDocs.totalHits;
    }

    public Document doc(int index) throws IOException {
        return this.searcher.doc(this.docId(index));
    }

    public Document doc(int index, FieldSelector selector) throws IOException {
        return this.searcher.doc(this.docId(index), selector);
    }

    public ScoreDoc scoreDoc(int index) throws IOException {
        if (index >= this.totalHits) {
            throw new SearchException("Not a valid ScoreDoc index: " + index);
        }
        if (index >= this.topDocs.scoreDocs.length) {
            this.updateTopDocs(2 * index);
        }
        return this.topDocs.scoreDocs[index];
    }

    public int docId(int index) throws IOException {
        return this.scoreDoc((int)index).doc;
    }

    public float score(int index) throws IOException {
        return this.scoreDoc((int)index).score;
    }

    public Explanation explain(int index) throws IOException {
        return this.searcher.explain(this.preparedQuery, this.docId(index));
    }

    private void updateTopDocs(int n) throws IOException {
        this.topDocs = this.sort == null ? this.searcher.search(this.preparedQuery, this.filter, n) : this.searcher.search(this.preparedQuery, this.filter, n, this.sort);
    }
}

