/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.event;

import java.lang.reflect.Array;
import java.util.Properties;
import org.hibernate.event.EventListeners;
import org.hibernate.event.PostCollectionRecreateEventListener;
import org.hibernate.event.PostCollectionRemoveEventListener;
import org.hibernate.event.PostCollectionUpdateEventListener;
import org.hibernate.event.PostDeleteEventListener;
import org.hibernate.event.PostInsertEventListener;
import org.hibernate.event.PostUpdateEventListener;
import org.hibernate.search.event.FullTextIndexCollectionEventListener;
import org.hibernate.search.event.FullTextIndexEventListener;
import org.hibernate.search.util.LoggerFactory;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventListenerRegister {
    private static final Logger log = LoggerFactory.make();

    public static void enableHibernateSearch(EventListeners listeners, Properties properties) {
        String enableSearchListeners = properties.getProperty("hibernate.search.autoregister_listeners");
        if ("false".equalsIgnoreCase(enableSearchListeners)) {
            log.info("Property hibernate.search.autoregister_listeners is set to false. No attempt will be made to register Hibernate Search event listeners.");
            return;
        }
        FullTextIndexEventListener searchListener = new FullTextIndexEventListener();
        listeners.setPostInsertEventListeners(EventListenerRegister.addIfNeeded(listeners.getPostInsertEventListeners(), searchListener, new PostInsertEventListener[]{searchListener}));
        listeners.setPostUpdateEventListeners(EventListenerRegister.addIfNeeded(listeners.getPostUpdateEventListeners(), searchListener, new PostUpdateEventListener[]{searchListener}));
        listeners.setPostDeleteEventListeners(EventListenerRegister.addIfNeeded(listeners.getPostDeleteEventListeners(), searchListener, new PostDeleteEventListener[]{searchListener}));
        listeners.setPostCollectionRecreateEventListeners(EventListenerRegister.addIfNeeded(listeners.getPostCollectionRecreateEventListeners(), searchListener, new PostCollectionRecreateEventListener[]{searchListener}));
        listeners.setPostCollectionRemoveEventListeners(EventListenerRegister.addIfNeeded(listeners.getPostCollectionRemoveEventListeners(), searchListener, new PostCollectionRemoveEventListener[]{searchListener}));
        listeners.setPostCollectionUpdateEventListeners(EventListenerRegister.addIfNeeded(listeners.getPostCollectionUpdateEventListeners(), searchListener, new PostCollectionUpdateEventListener[]{searchListener}));
    }

    private static <T> T[] addIfNeeded(T[] listeners, T searchEventListener, T[] toUseOnNull) {
        if (listeners == null) {
            return toUseOnNull;
        }
        if (!EventListenerRegister.isPresentInListeners(listeners)) {
            return EventListenerRegister.appendToArray(listeners, searchEventListener);
        }
        return listeners;
    }

    private static <T> T[] appendToArray(T[] listeners, T newElement) {
        int length = listeners.length;
        Object[] ret = (Object[])Array.newInstance(listeners.getClass().getComponentType(), length + 1);
        System.arraycopy(listeners, 0, ret, 0, length);
        ret[length] = newElement;
        return ret;
    }

    private static boolean isPresentInListeners(Object[] listeners) {
        for (Object eventListener : listeners) {
            if (FullTextIndexEventListener.class == eventListener.getClass()) {
                return true;
            }
            if (FullTextIndexCollectionEventListener.class != eventListener.getClass()) continue;
            return true;
        }
        return false;
    }
}

