/* $Id: MassIndexerProgressMonitor.java 17630 2009-10-06 13:38:43Z sannegrinovero $
 * 
 * Hibernate, Relational Persistence for Idiomatic Java
 * 
 * Copyright (c) 2009, Red Hat, Inc. and/or its affiliates or third-party contributors as
 * indicated by the @author tags or express copyright attribution
 * statements applied by the authors.  All third-party contributions are
 * distributed under license by Red Hat, Inc.
 * 
 * This copyrighted material is made available to anyone wishing to use, modify,
 * copy, or redistribute it subject to the terms and conditions of the GNU
 * Lesser General Public License, as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this distribution; if not, write to:
 * Free Software Foundation, Inc.
 * 51 Franklin Street, Fifth Floor
 * Boston, MA  02110-1301  USA
 */
package org.hibernate.search.batchindexing;

/**
 * As a MassIndexer can take some time to finish it's job,
 * a MassIndexerProgressMonitor can be defined in the configuration
 * property hibernate.search.worker.indexing.monitor
 * implementing this interface to track indexing performance.
 * 
 * Implementors must:
 * 	be threadsafe
 *  have a no-arg constructor.
 * 
 * @author Sanne Grinovero
 */
public interface MassIndexerProgressMonitor {

	/**
	 * The number of documents sent to the backend;
	 * This is called several times during
	 * the indexing process.
	 * @param increment
	 */
	void documentsAdded(long increment);

	/**
	 * The number of Documents built;
	 * This is called several times and concurrently during
	 * the indexing process.
	 * @param number
	 */
	void documentsBuilt(int number);

	/**
	 * The number of entities loaded from database;
	 * This is called several times and concurrently during
	 * the indexing process.
	 * @param size
	 */
	void entitiesLoaded(int size);

	/**
	 * The total count of entities to be indexed is
	 * added here; It could be called more than once,
	 * the implementation should add them up.
	 * This is called several times and concurrently during
	 * the indexing process.
	 * @param count
	 */
	void addToTotalCount(long count);

}
