/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.batchlucene;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.hibernate.search.SearchException;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.Workspace;
import org.hibernate.search.backend.impl.lucene.works.LuceneWorkDelegate;
import org.hibernate.search.backend.impl.lucene.works.LuceneWorkVisitor;
import org.hibernate.search.batchindexing.Executors;
import org.hibernate.search.batchindexing.MassIndexerProgressMonitor;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.util.LoggerFactory;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DirectoryProviderWorkspace {
    private static final Logger log = LoggerFactory.make();
    private final ExecutorService executor;
    private final LuceneWorkVisitor visitor;
    private final Workspace workspace;
    private final MassIndexerProgressMonitor monitor;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    DirectoryProviderWorkspace(SearchFactoryImplementor searchFactoryImp, DirectoryProvider<?> dp, MassIndexerProgressMonitor monitor, int maxThreads) {
        if (maxThreads < 1) {
            throw new IllegalArgumentException("maxThreads needs to be at least 1");
        }
        this.monitor = monitor;
        this.workspace = new Workspace(searchFactoryImp, dp);
        this.visitor = new LuceneWorkVisitor(this.workspace);
        this.executor = Executors.newFixedThreadPool(maxThreads, "indexwriter");
    }

    public void stopAndFlush(long timeout, TimeUnit unit) throws InterruptedException {
        this.checkIsNotClosed();
        this.executor.shutdown();
        this.executor.awaitTermination(timeout, unit);
        this.workspace.commitIndexWriter();
    }

    public void doWorkInSync(LuceneWork work) {
        this.checkIsNotClosed();
        LuceneWorkDelegate delegate = work.getWorkDelegate(this.visitor);
        delegate.performWork(work, this.workspace.getIndexWriter(true));
        delegate.logWorkDone(work, this.monitor);
    }

    public void enqueueAsyncWork(LuceneWork work) {
        this.executor.execute(new AsyncIndexRunnable(work));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            try {
                if (this.executor.isShutdown()) return;
                log.error("Terminating batch work! Index might end up in inconsistent state.");
                this.executor.shutdownNow();
                return;
            }
            finally {
                this.workspace.closeIndexWriter();
            }
        } else {
            this.checkIsNotClosed();
        }
    }

    private void checkIsNotClosed() {
        if (this.closed.get()) {
            throw new SearchException("Batch DirectoryProviderWorkspace is closed already");
        }
    }

    private class AsyncIndexRunnable
    implements Runnable {
        private final LuceneWork work;

        AsyncIndexRunnable(LuceneWork work) {
            this.work = work;
        }

        public void run() {
            DirectoryProviderWorkspace.this.doWorkInSync(this.work);
        }
    }
}

