/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene;

import java.util.List;
import java.util.Map;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.impl.lucene.DpSelectionVisitor;
import org.hibernate.search.backend.impl.lucene.PerDPResources;
import org.hibernate.search.backend.impl.lucene.QueueProcessors;
import org.hibernate.search.engine.DocumentBuilderIndexedEntity;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.store.IndexShardingStrategy;
import org.hibernate.search.util.LoggerFactory;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LuceneBackendQueueProcessor
implements Runnable {
    private final List<LuceneWork> queue;
    private final SearchFactoryImplementor searchFactoryImplementor;
    private final Map<DirectoryProvider, PerDPResources> resourcesMap;
    private final boolean sync;
    private static final DpSelectionVisitor providerSelectionVisitor = new DpSelectionVisitor();
    private static final Logger log = LoggerFactory.make();

    LuceneBackendQueueProcessor(List<LuceneWork> queue, SearchFactoryImplementor searchFactoryImplementor, Map<DirectoryProvider, PerDPResources> resourcesMap, boolean syncMode) {
        this.sync = syncMode;
        this.queue = queue;
        this.searchFactoryImplementor = searchFactoryImplementor;
        this.resourcesMap = resourcesMap;
    }

    @Override
    public void run() {
        QueueProcessors processors = new QueueProcessors(this.resourcesMap);
        try {
            for (LuceneWork work : this.queue) {
                Class entityType = work.getEntityClass();
                DocumentBuilderIndexedEntity documentBuilder = this.searchFactoryImplementor.getDocumentBuilderIndexedEntity(entityType);
                IndexShardingStrategy shardingStrategy = documentBuilder.getDirectoryProviderSelectionStrategy();
                work.getWorkDelegate(providerSelectionVisitor).addAsPayLoadsToQueue(work, shardingStrategy, processors);
            }
            processors.runAll(this.sync);
        }
        catch (InterruptedException e) {
            log.error("Index update task has been interrupted", (Throwable)e);
        }
    }
}

