/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.batchindexing;

import java.io.Serializable;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import org.hibernate.CacheMode;
import org.hibernate.SessionFactory;
import org.hibernate.search.SearchException;
import org.hibernate.search.backend.impl.batchlucene.BatchBackend;
import org.hibernate.search.batchindexing.EntityConsumerLuceneworkProducer;
import org.hibernate.search.batchindexing.Executors;
import org.hibernate.search.batchindexing.IdentifierConsumerEntityProducer;
import org.hibernate.search.batchindexing.IdentifierProducer;
import org.hibernate.search.batchindexing.MassIndexerProgressMonitor;
import org.hibernate.search.batchindexing.ProducerConsumerQueue;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.util.LoggerFactory;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchIndexingWorkspace
implements Runnable {
    private static final Logger log = LoggerFactory.make();
    private final SearchFactoryImplementor searchFactory;
    private final SessionFactory sessionFactory;
    private final ThreadPoolExecutor execIdentifiersLoader;
    private final ProducerConsumerQueue<List<Serializable>> fromIdentifierListToEntities;
    private final ThreadPoolExecutor execFirstLoader;
    private final ProducerConsumerQueue<Object> fromEntityToAddwork;
    private final ThreadPoolExecutor execDocBuilding;
    private final int objectLoadingThreadNum;
    private final int luceneworkerBuildingThreadNum;
    private final Class<?> indexedType;
    private final CountDownLatch producerEndSignal;
    private final CountDownLatch endAllSignal;
    private final MassIndexerProgressMonitor monitor;
    private final CacheMode cacheMode;
    private final int objectLoadingBatchSize;
    private final BatchBackend backend;
    private final int objectsLimit;

    public BatchIndexingWorkspace(SearchFactoryImplementor searchFactoryImplementor, SessionFactory sessionFactory, Class<?> entityType, int objectLoadingThreads, int collectionLoadingThreads, CacheMode cacheMode, int objectLoadingBatchSize, CountDownLatch endAllSignal, MassIndexerProgressMonitor monitor, BatchBackend backend, int objectsLimit) {
        this.indexedType = entityType;
        this.searchFactory = searchFactoryImplementor;
        this.sessionFactory = sessionFactory;
        this.objectLoadingThreadNum = objectLoadingThreads;
        this.luceneworkerBuildingThreadNum = collectionLoadingThreads;
        this.cacheMode = cacheMode;
        this.objectLoadingBatchSize = objectLoadingBatchSize;
        this.backend = backend;
        this.execIdentifiersLoader = Executors.newFixedThreadPool(1, "identifierloader");
        this.execFirstLoader = Executors.newFixedThreadPool(this.objectLoadingThreadNum, "entityloader");
        this.execDocBuilding = Executors.newFixedThreadPool(this.luceneworkerBuildingThreadNum, "collectionsloader");
        this.fromIdentifierListToEntities = new ProducerConsumerQueue(1);
        this.fromEntityToAddwork = new ProducerConsumerQueue(this.objectLoadingThreadNum);
        this.endAllSignal = endAllSignal;
        this.producerEndSignal = new CountDownLatch(this.luceneworkerBuildingThreadNum);
        this.monitor = monitor;
        this.objectsLimit = objectsLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            int i;
            for (i = 0; i < this.luceneworkerBuildingThreadNum; ++i) {
                this.execDocBuilding.execute(new EntityConsumerLuceneworkProducer(this.fromEntityToAddwork, this.monitor, this.sessionFactory, this.producerEndSignal, this.searchFactory, this.cacheMode, this.backend));
            }
            for (i = 0; i < this.objectLoadingThreadNum; ++i) {
                this.execFirstLoader.execute(new IdentifierConsumerEntityProducer(this.fromIdentifierListToEntities, this.fromEntityToAddwork, this.monitor, this.sessionFactory, this.cacheMode, this.indexedType));
            }
            this.execIdentifiersLoader.execute(new IdentifierProducer(this.fromIdentifierListToEntities, this.sessionFactory, this.objectLoadingBatchSize, this.indexedType, this.monitor, this.objectsLimit));
            this.execIdentifiersLoader.shutdown();
            this.execFirstLoader.shutdown();
            this.execDocBuilding.shutdown();
            try {
                this.producerEndSignal.await();
                log.debug("All work for type {} has been produced", (Object)this.indexedType.getName());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new SearchException("Interrupted on batch Indexing; index will be left in unknown state!", e);
            }
        }
        finally {
            this.endAllSignal.countDown();
        }
    }
}

