/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.event;

import java.util.WeakHashMap;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.cfg.SearchConfigurationFromHibernateCore;
import org.hibernate.search.impl.SearchFactoryImpl;

public class ContextHolder {
    private static final ThreadLocal<WeakHashMap<Configuration, SearchFactoryImpl>> contexts = new ThreadLocal();

    public static SearchFactoryImpl getOrBuildSearchFactory(Configuration cfg) {
        SearchFactoryImpl searchFactory;
        WeakHashMap<Object, SearchFactoryImpl> contextMap = contexts.get();
        if (contextMap == null) {
            contextMap = new WeakHashMap(2);
            contexts.set(contextMap);
        }
        if ((searchFactory = contextMap.get(cfg)) == null) {
            searchFactory = new SearchFactoryImpl(new SearchConfigurationFromHibernateCore(cfg));
            contextMap.put(cfg, searchFactory);
        }
        return searchFactory;
    }
}

