/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.v2.impl;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.search.SearchException;
import org.hibernate.search.SearchFactory;
import org.hibernate.search.query.dsl.v2.TermContext;
import org.hibernate.search.query.dsl.v2.TermCustomization;
import org.hibernate.search.query.dsl.v2.TermFuzzy;
import org.hibernate.search.query.dsl.v2.TermMatchingContext;
import org.hibernate.search.query.dsl.v2.impl.QueryCustomizer;

class ConnectedTermContext
implements TermContext {
    private final SearchFactory factory;
    private final Analyzer queryAnalyzer;

    public ConnectedTermContext(Analyzer queryAnalyzer, SearchFactory factory) {
        this.factory = factory;
        this.queryAnalyzer = queryAnalyzer;
    }

    public TermMatchingContext on(String field) {
        return new ConnectedTermMatchingContext(field, this.queryAnalyzer, this.factory);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConnectedTermCustomization
    implements TermCustomization,
    TermFuzzy {
        private final SearchFactory factory;
        private final String field;
        private final String text;
        private final Analyzer queryAnalyzer;
        private final QueryCustomizer queryCustomizer;
        private boolean ignoreAnalyzer;
        private Approximation approximation = Approximation.EXACT;
        private float threshold = 0.5f;
        private int prefixLength = 0;

        public ConnectedTermCustomization(String text, String field, Analyzer queryAnalyzer, SearchFactory factory) {
            this.factory = factory;
            this.field = field;
            this.text = text;
            this.queryAnalyzer = queryAnalyzer;
            this.queryCustomizer = new QueryCustomizer();
        }

        @Override
        public TermCustomization ignoreAnalyzer() {
            this.ignoreAnalyzer = true;
            return this;
        }

        @Override
        public TermFuzzy fuzzy() {
            if (this.approximation != Approximation.EXACT) {
                throw new IllegalStateException("Cannot call fuzzy() and wildcard() on the same term query");
            }
            this.approximation = Approximation.FUZZY;
            return this;
        }

        @Override
        public TermCustomization wildcard() {
            if (this.approximation != Approximation.EXACT) {
                throw new IllegalStateException("Cannot call fuzzy() and wildcard() on the same term query");
            }
            this.approximation = Approximation.WILDCARD;
            return this;
        }

        @Override
        public TermCustomization boostedTo(float boost) {
            this.queryCustomizer.boostedTo(boost);
            return this;
        }

        @Override
        public TermCustomization constantScore() {
            this.queryCustomizer.constantScore();
            return this;
        }

        @Override
        public TermCustomization filter(Filter filter) {
            this.queryCustomizer.filter(filter);
            return this;
        }

        @Override
        public Query createQuery() {
            Query result;
            if (this.ignoreAnalyzer) {
                result = this.createTermQuery(this.text);
            } else {
                List<String> terms;
                try {
                    terms = this.getAllTermsFromText(this.field, this.text, this.queryAnalyzer);
                }
                catch (IOException e) {
                    throw new AssertionFailure("IO exception while reading String stream??", (Throwable)e);
                }
                if (terms.size() == 0) {
                    throw new SearchException("try to search with an empty string: " + this.field);
                }
                if (terms.size() == 1) {
                    result = this.createTermQuery(terms.get(0));
                } else {
                    BooleanQuery booleanQuery = new BooleanQuery();
                    for (String term : terms) {
                        Query termQuery = this.createTermQuery(term);
                        booleanQuery.add(termQuery, BooleanClause.Occur.SHOULD);
                    }
                    result = booleanQuery;
                }
            }
            return this.queryCustomizer.setWrappedQuery(result).createQuery();
        }

        private Query createTermQuery(String term) {
            TermQuery query;
            switch (this.approximation) {
                case EXACT: {
                    query = new TermQuery(new Term(this.field, term));
                    break;
                }
                case WILDCARD: {
                    query = new WildcardQuery(new Term(this.field, term));
                    break;
                }
                case FUZZY: {
                    query = new FuzzyQuery(new Term(this.field, term), this.threshold, this.prefixLength);
                    break;
                }
                default: {
                    throw new AssertionFailure("Unknown approximation: " + (Object)((Object)this.approximation));
                }
            }
            return query;
        }

        private List<String> getAllTermsFromText(String fieldName, String text, Analyzer analyzer) throws IOException {
            ArrayList<String> terms = new ArrayList<String>();
            if (this.approximation == Approximation.WILDCARD) {
                terms.add(text);
            } else {
                StringReader reader = new StringReader(text);
                TokenStream stream = analyzer.reusableTokenStream(fieldName, (Reader)reader);
                TermAttribute attribute = (TermAttribute)stream.addAttribute(TermAttribute.class);
                stream.reset();
                while (stream.incrementToken()) {
                    if (attribute.termLength() <= 0) continue;
                    String term = attribute.term();
                    terms.add(term);
                }
                stream.end();
                stream.close();
            }
            return terms;
        }

        @Override
        public TermFuzzy threshold(float threshold) {
            this.threshold = threshold;
            return this;
        }

        @Override
        public TermFuzzy prefixLength(int prefixLength) {
            this.prefixLength = prefixLength;
            return this;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum Approximation {
            EXACT,
            WILDCARD,
            FUZZY;

        }
    }

    public static class ConnectedTermMatchingContext
    implements TermMatchingContext {
        private final SearchFactory factory;
        private final String field;
        private final Analyzer queryAnalyzer;

        public ConnectedTermMatchingContext(String field, Analyzer queryAnalyzer, SearchFactory factory) {
            this.factory = factory;
            this.field = field;
            this.queryAnalyzer = queryAnalyzer;
        }

        public TermCustomization matches(String text) {
            return new ConnectedTermCustomization(text, this.field, this.queryAnalyzer, this.factory);
        }
    }
}

