/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.event;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Map;
import javax.transaction.Synchronization;
import org.hibernate.Session;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.EntityEntry;
import org.hibernate.event.AbstractCollectionEvent;
import org.hibernate.event.AbstractEvent;
import org.hibernate.event.Destructible;
import org.hibernate.event.EventSource;
import org.hibernate.event.FlushEvent;
import org.hibernate.event.FlushEventListener;
import org.hibernate.event.Initializable;
import org.hibernate.event.PostCollectionRecreateEvent;
import org.hibernate.event.PostCollectionRecreateEventListener;
import org.hibernate.event.PostCollectionRemoveEvent;
import org.hibernate.event.PostCollectionRemoveEventListener;
import org.hibernate.event.PostCollectionUpdateEvent;
import org.hibernate.event.PostCollectionUpdateEventListener;
import org.hibernate.event.PostDeleteEvent;
import org.hibernate.event.PostDeleteEventListener;
import org.hibernate.event.PostInsertEvent;
import org.hibernate.event.PostInsertEventListener;
import org.hibernate.event.PostUpdateEvent;
import org.hibernate.event.PostUpdateEventListener;
import org.hibernate.search.backend.Work;
import org.hibernate.search.backend.WorkType;
import org.hibernate.search.backend.impl.EventSourceTransactionContext;
import org.hibernate.search.cfg.SearchConfigurationFromHibernateCore;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.event.ContextHolder;
import org.hibernate.search.impl.SearchFactoryImpl;
import org.hibernate.search.util.LoggerFactory;
import org.hibernate.search.util.WeakIdentityHashMap;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FullTextIndexEventListener
implements PostDeleteEventListener,
PostInsertEventListener,
PostUpdateEventListener,
PostCollectionRecreateEventListener,
PostCollectionRemoveEventListener,
PostCollectionUpdateEventListener,
FlushEventListener,
Initializable,
Destructible {
    private static final Logger log = LoggerFactory.make();
    protected boolean used;
    protected SearchFactoryImplementor searchFactoryImplementor;
    private final Installation installation;
    private final transient Map<Session, Synchronization> flushSynch = new WeakIdentityHashMap<Session, Synchronization>(0);

    public FullTextIndexEventListener() {
        this.installation = Installation.MULTIPLE_INSTANCE;
    }

    public FullTextIndexEventListener(Installation installation) {
        this.installation = installation;
    }

    public void initialize(Configuration cfg) {
        if (this.installation != Installation.SINGLE_INSTANCE) {
            log.debug("Storing SearchFactory in ThreadLocal");
            this.searchFactoryImplementor = ContextHolder.getOrBuildSearchFactory(cfg);
        } else if (this.searchFactoryImplementor == null) {
            this.searchFactoryImplementor = new SearchFactoryImpl(new SearchConfigurationFromHibernateCore(cfg));
        }
        String indexingStrategy = this.searchFactoryImplementor.getIndexingStrategy();
        if ("event".equals(indexingStrategy)) {
            this.used = this.searchFactoryImplementor.getDocumentBuildersIndexedEntities().size() != 0;
        } else if ("manual".equals(indexingStrategy)) {
            this.used = false;
        }
        log.debug("Hibernate Search event listeners " + (this.used ? "activated" : "desactivated"));
    }

    public SearchFactoryImplementor getSearchFactoryImplementor() {
        return this.searchFactoryImplementor;
    }

    public void onPostDelete(PostDeleteEvent event) {
        if (this.used) {
            Class<?> entityType = event.getEntity().getClass();
            if (this.searchFactoryImplementor.getDocumentBuildersIndexedEntities().containsKey(entityType) || this.searchFactoryImplementor.getDocumentBuilderContainedEntity(entityType) != null) {
                this.processWork(event.getEntity(), event.getId(), WorkType.DELETE, (AbstractEvent)event);
            }
        }
    }

    public void onPostInsert(PostInsertEvent event) {
        Object entity;
        if (this.used && (this.searchFactoryImplementor.getDocumentBuilderIndexedEntity((entity = event.getEntity()).getClass()) != null || this.searchFactoryImplementor.getDocumentBuilderContainedEntity(entity.getClass()) != null)) {
            Serializable id = event.getId();
            this.processWork(entity, id, WorkType.ADD, (AbstractEvent)event);
        }
    }

    public void onPostUpdate(PostUpdateEvent event) {
        Object entity;
        if (this.used && (this.searchFactoryImplementor.getDocumentBuilderIndexedEntity((entity = event.getEntity()).getClass()) != null || this.searchFactoryImplementor.getDocumentBuilderContainedEntity(entity.getClass()) != null)) {
            Serializable id = event.getId();
            this.processWork(entity, id, WorkType.UPDATE, (AbstractEvent)event);
        }
    }

    protected <T> void processWork(T entity, Serializable id, WorkType workType, AbstractEvent event) {
        Work<T> work = new Work<T>(entity, id, workType);
        EventSourceTransactionContext transactionContext = new EventSourceTransactionContext(event.getSession());
        this.searchFactoryImplementor.getWorker().performWork(work, transactionContext);
    }

    public void cleanup() {
        this.searchFactoryImplementor.close();
        this.temptativeContextCleaning();
    }

    private void temptativeContextCleaning() {
        if (this.installation != Installation.SINGLE_INSTANCE) {
            ContextHolder.removeSearchFactoryFromCache(this.searchFactoryImplementor);
        }
    }

    public void onPostRecreateCollection(PostCollectionRecreateEvent event) {
        this.processCollectionEvent((AbstractCollectionEvent)event);
    }

    public void onPostRemoveCollection(PostCollectionRemoveEvent event) {
        this.processCollectionEvent((AbstractCollectionEvent)event);
    }

    public void onPostUpdateCollection(PostCollectionUpdateEvent event) {
        this.processCollectionEvent((AbstractCollectionEvent)event);
    }

    protected void processCollectionEvent(AbstractCollectionEvent event) {
        Object entity = event.getAffectedOwnerOrNull();
        if (entity == null) {
            return;
        }
        if (this.used && (this.searchFactoryImplementor.getDocumentBuilderIndexedEntity(entity.getClass()) != null || this.searchFactoryImplementor.getDocumentBuilderContainedEntity(entity.getClass()) != null)) {
            Serializable id = this.getId(entity, event);
            if (id == null) {
                log.warn("Unable to reindex entity on collection change, id cannot be extracted: {}", (Object)event.getAffectedOwnerEntityName());
                return;
            }
            this.processWork(entity, id, WorkType.COLLECTION, (AbstractEvent)event);
        }
    }

    private Serializable getId(Object entity, AbstractCollectionEvent event) {
        Serializable id = event.getAffectedOwnerIdOrNull();
        if (id == null) {
            EntityEntry entityEntry = event.getSession().getPersistenceContext().getEntry(entity);
            id = entityEntry == null ? null : entityEntry.getId();
        }
        return id;
    }

    public void onFlush(FlushEvent event) {
        EventSource session;
        Synchronization synchronization;
        if (this.used && (synchronization = this.flushSynch.get(session = event.getSession())) != null) {
            this.flushSynch.remove(session);
            log.debug("flush event causing index update out of transaction");
            synchronization.beforeCompletion();
            synchronization.afterCompletion(3);
        }
    }

    public void addSynchronization(EventSource eventSource, Synchronization synchronization) {
        this.flushSynch.put((Session)eventSource, synchronization);
    }

    private void writeObject(ObjectOutputStream os) throws IOException {
        os.defaultWriteObject();
        this.temptativeContextCleaning();
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException, SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        is.defaultReadObject();
        Class<FullTextIndexEventListener> cl = FullTextIndexEventListener.class;
        Field f = cl.getDeclaredField("flushSynch");
        f.setAccessible(true);
        WeakIdentityHashMap flushSynch = new WeakIdentityHashMap(0);
        f.set(this, flushSynch);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Installation {
        SINGLE_INSTANCE,
        MULTIPLE_INSTANCE;

    }
}

