/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl;

import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.search.query.dsl.AbstractTermQueryBuilder;
import org.hibernate.search.query.dsl.TermQueryBuilderDataStore;
import org.hibernate.search.query.dsl.UnbuildableTermQueryBuilderOnSearch;

public class BuildableTermQueryBuilder
extends AbstractTermQueryBuilder {
    public BuildableTermQueryBuilder(TermQueryBuilderDataStore dataStore) {
        this.dataStore = dataStore;
    }

    public UnbuildableTermQueryBuilderOnSearch on(String field) {
        return new UnbuildableTermQueryBuilderOnSearch(this.dataStore, field);
    }

    public Query build() {
        List<Term> terms = this.dataStore.getTerms();
        TermQuery tq = new TermQuery(terms.get(0));
        TermQuery[] termQueries = new TermQuery[terms.size() - 1];
        for (int i = 1; i < terms.size(); ++i) {
            termQueries[i - 1] = new TermQuery(terms.get(i));
        }
        tq = tq.combine((Query[])termQueries);
        return tq;
    }
}

