/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.v2.impl;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.search.SearchException;
import org.hibernate.search.SearchFactory;
import org.hibernate.search.query.dsl.v2.TermTermination;
import org.hibernate.search.query.dsl.v2.impl.FieldContext;
import org.hibernate.search.query.dsl.v2.impl.QueryContext;
import org.hibernate.search.query.dsl.v2.impl.QueryCustomizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectedMultiFieldsTermQueryBuilder
implements TermTermination {
    private final String text;
    private final Analyzer queryAnalyzer;
    private final QueryCustomizer queryCustomizer;
    private final QueryContext queryContext;
    private final List<FieldContext> fieldContexts;

    public ConnectedMultiFieldsTermQueryBuilder(QueryContext queryContext, String text, List<FieldContext> fieldContexts, QueryCustomizer queryCustomizer, Analyzer queryAnalyzer, SearchFactory factory) {
        this.queryContext = queryContext;
        this.text = text;
        this.queryAnalyzer = queryAnalyzer;
        this.queryCustomizer = queryCustomizer;
        this.fieldContexts = fieldContexts;
    }

    @Override
    public Query createQuery() {
        int size = this.fieldContexts.size();
        if (size == 1) {
            return this.queryCustomizer.setWrappedQuery(this.createQuery(this.fieldContexts.get(0))).createQuery();
        }
        BooleanQuery aggregatedFieldsQuery = new BooleanQuery();
        for (FieldContext fieldContext : this.fieldContexts) {
            aggregatedFieldsQuery.add(this.createQuery(fieldContext), BooleanClause.Occur.SHOULD);
        }
        return this.queryCustomizer.setWrappedQuery((Query)aggregatedFieldsQuery).createQuery();
    }

    public Query createQuery(FieldContext fieldContext) {
        Query perFieldQuery;
        if (fieldContext.isIgnoreAnalyzer()) {
            perFieldQuery = this.createTermQuery(fieldContext, this.text);
        } else {
            List<String> terms;
            try {
                terms = this.getAllTermsFromText(fieldContext.getField(), this.text, this.queryAnalyzer);
            }
            catch (IOException e) {
                throw new AssertionFailure("IO exception while reading String stream??", (Throwable)e);
            }
            if (terms.size() == 0) {
                throw new SearchException("try to search with an empty string: " + fieldContext.getField());
            }
            if (terms.size() == 1) {
                perFieldQuery = this.createTermQuery(fieldContext, terms.get(0));
            } else {
                BooleanQuery booleanQuery = new BooleanQuery();
                for (String term : terms) {
                    Query termQuery = this.createTermQuery(fieldContext, term);
                    booleanQuery.add(termQuery, BooleanClause.Occur.SHOULD);
                }
                perFieldQuery = booleanQuery;
            }
        }
        return fieldContext.getFieldCustomizer().setWrappedQuery(perFieldQuery).createQuery();
    }

    private Query createTermQuery(FieldContext fieldContext, String term) {
        TermQuery query;
        switch (this.queryContext.getApproximation()) {
            case EXACT: {
                query = new TermQuery(new Term(fieldContext.getField(), term));
                break;
            }
            case WILDCARD: {
                query = new WildcardQuery(new Term(fieldContext.getField(), term));
                break;
            }
            case FUZZY: {
                query = new FuzzyQuery(new Term(fieldContext.getField(), term), this.queryContext.getThreshold(), this.queryContext.getPrefixLength());
                break;
            }
            default: {
                throw new AssertionFailure("Unknown approximation: " + (Object)((Object)this.queryContext.getApproximation()));
            }
        }
        return query;
    }

    private List<String> getAllTermsFromText(String fieldName, String text, Analyzer analyzer) throws IOException {
        ArrayList<String> terms = new ArrayList<String>();
        if (this.queryContext.getApproximation() == QueryContext.Approximation.WILDCARD) {
            terms.add(text);
        } else {
            StringReader reader = new StringReader(text);
            TokenStream stream = analyzer.reusableTokenStream(fieldName, (Reader)reader);
            TermAttribute attribute = (TermAttribute)stream.addAttribute(TermAttribute.class);
            stream.reset();
            while (stream.incrementToken()) {
                if (attribute.termLength() <= 0) continue;
                String term = attribute.term();
                terms.add(term);
            }
            stream.end();
            stream.close();
        }
        return terms;
    }
}

