/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.v2.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.hibernate.search.SearchFactory;
import org.hibernate.search.query.dsl.v2.TermMatchingContext;
import org.hibernate.search.query.dsl.v2.TermTermination;
import org.hibernate.search.query.dsl.v2.impl.ConnectedMultiFieldsTermQueryBuilder;
import org.hibernate.search.query.dsl.v2.impl.FieldContext;
import org.hibernate.search.query.dsl.v2.impl.QueryContext;
import org.hibernate.search.query.dsl.v2.impl.QueryCustomizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectedTermMatchingContext
implements TermMatchingContext {
    private final SearchFactory factory;
    private final Analyzer queryAnalyzer;
    private final QueryCustomizer queryCustomizer;
    private final QueryContext queryContext;
    private final List<FieldContext> fieldContexts;
    private int firstOfContext = 0;

    public ConnectedTermMatchingContext(QueryContext queryContext, String field, QueryCustomizer queryCustomizer, Analyzer queryAnalyzer, SearchFactory factory) {
        this.factory = factory;
        this.queryAnalyzer = queryAnalyzer;
        this.queryCustomizer = queryCustomizer;
        this.queryContext = queryContext;
        this.fieldContexts = new ArrayList<FieldContext>(4);
        this.fieldContexts.add(new FieldContext(field));
    }

    public ConnectedTermMatchingContext(QueryContext queryContext, String[] fields, QueryCustomizer queryCustomizer, Analyzer queryAnalyzer, SearchFactory factory) {
        this.factory = factory;
        this.queryAnalyzer = queryAnalyzer;
        this.queryCustomizer = queryCustomizer;
        this.queryContext = queryContext;
        this.fieldContexts = new ArrayList<FieldContext>(fields.length);
        for (String field : fields) {
            this.fieldContexts.add(new FieldContext(field));
        }
    }

    @Override
    public TermTermination matching(String text) {
        return new ConnectedMultiFieldsTermQueryBuilder(this.queryContext, text, this.fieldContexts, this.queryCustomizer, this.queryAnalyzer, this.factory);
    }

    @Override
    public TermMatchingContext andField(String field) {
        this.fieldContexts.add(new FieldContext(field));
        this.firstOfContext = this.fieldContexts.size() - 1;
        return this;
    }

    @Override
    public TermMatchingContext boostedTo(float boost) {
        for (FieldContext fieldContext : this.getCurrentFieldContexts()) {
            fieldContext.getFieldCustomizer().boostedTo(boost);
        }
        return this;
    }

    private List<FieldContext> getCurrentFieldContexts() {
        return this.fieldContexts.subList(this.firstOfContext, this.fieldContexts.size());
    }

    @Override
    public TermMatchingContext ignoreAnalyzer() {
        for (FieldContext fieldContext : this.getCurrentFieldContexts()) {
            fieldContext.setIgnoreAnalyzer(true);
        }
        return this;
    }
}

