package org.hibernate.search.query.dsl.v2.impl;

import org.apache.lucene.analysis.Analyzer;

import org.hibernate.search.SearchFactory;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.query.dsl.v2.AllContext;
import org.hibernate.search.query.dsl.v2.BooleanJunction;
import org.hibernate.search.query.dsl.v2.FuzzyContext;
import org.hibernate.search.query.dsl.v2.PhraseContext;
import org.hibernate.search.query.dsl.v2.QueryBuilder;
import org.hibernate.search.query.dsl.v2.RangeContext;
import org.hibernate.search.query.dsl.v2.TermContext;
import org.hibernate.search.query.dsl.v2.WildcardContext;

/**
 * Assuming connection with the search factory
 * 
 * @author Emmanuel Bernard
 */
public class ConnectedQueryBuilder implements QueryBuilder {
	private final QueryBuildingContext context;

	public ConnectedQueryBuilder(QueryBuildingContext context) {
		this.context = context;
	}

	public TermContext keyword() {
		return new ConnectedTermContext(context);
	}

	public RangeContext range() {
		return new ConnectedRangeContext(context);
	}

	public PhraseContext phrase() {
		return new ConnectedPhraseContext(context);
	}

	//fixme Have to use raw types but would be nice to not have to
	public BooleanJunction bool() {
		return new BooleanQueryBuilder();
	}

	public AllContext all() {
		return new ConnectedAllContext();
	}
}
