/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.v2.impl;

import org.apache.lucene.search.Filter;
import org.hibernate.search.query.dsl.v2.FuzzyContext;
import org.hibernate.search.query.dsl.v2.TermMatchingContext;
import org.hibernate.search.query.dsl.v2.impl.ConnectedTermMatchingContext;
import org.hibernate.search.query.dsl.v2.impl.QueryBuildingContext;
import org.hibernate.search.query.dsl.v2.impl.QueryCustomizer;
import org.hibernate.search.query.dsl.v2.impl.TermQueryContext;

class ConnectedFuzzyContext
implements FuzzyContext {
    private final QueryBuildingContext queryContext;
    private final QueryCustomizer queryCustomizer;
    private final TermQueryContext termContext;

    public ConnectedFuzzyContext(QueryCustomizer queryCustomizer, QueryBuildingContext queryContext) {
        this.queryCustomizer = queryCustomizer;
        this.termContext = new TermQueryContext(TermQueryContext.Approximation.FUZZY);
        this.queryContext = queryContext;
    }

    public TermMatchingContext onField(String field) {
        return new ConnectedTermMatchingContext(this.termContext, field, this.queryCustomizer, this.queryContext);
    }

    public ConnectedFuzzyContext withThreshold(float threshold) {
        this.termContext.setThreshold(threshold);
        return this;
    }

    public ConnectedFuzzyContext withPrefixLength(int prefixLength) {
        this.termContext.setPrefixLength(prefixLength);
        return this;
    }

    public FuzzyContext boostedTo(float boost) {
        this.queryCustomizer.boostedTo(boost);
        return this;
    }

    public FuzzyContext withConstantScore() {
        this.queryCustomizer.withConstantScore();
        return this;
    }

    public FuzzyContext filteredBy(Filter filter) {
        this.queryCustomizer.filteredBy(filter);
        return this;
    }
}

