/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.v2.impl;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.search.query.dsl.v2.PhraseMatchingContext;
import org.hibernate.search.query.dsl.v2.PhraseTermination;
import org.hibernate.search.query.dsl.v2.impl.ConnectedMultiFieldsPhraseQueryBuilder;
import org.hibernate.search.query.dsl.v2.impl.FieldContext;
import org.hibernate.search.query.dsl.v2.impl.PhraseQueryContext;
import org.hibernate.search.query.dsl.v2.impl.QueryBuildingContext;
import org.hibernate.search.query.dsl.v2.impl.QueryCustomizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectedPhraseMatchingContext
implements PhraseMatchingContext {
    private final QueryBuildingContext queryContext;
    private final QueryCustomizer queryCustomizer;
    private final PhraseQueryContext phraseContext;
    private final List<FieldContext> fieldContexts;
    private int firstOfContext = 0;

    public ConnectedPhraseMatchingContext(String fieldName, PhraseQueryContext phraseContext, QueryCustomizer queryCustomizer, QueryBuildingContext queryContext) {
        this.queryContext = queryContext;
        this.queryCustomizer = queryCustomizer;
        this.phraseContext = phraseContext;
        this.fieldContexts = new ArrayList<FieldContext>(4);
        this.fieldContexts.add(new FieldContext(fieldName));
    }

    @Override
    public PhraseMatchingContext andField(String field) {
        this.fieldContexts.add(new FieldContext(field));
        this.firstOfContext = this.fieldContexts.size() - 1;
        return this;
    }

    @Override
    public PhraseTermination sentence(String sentence) {
        this.phraseContext.setSentence(sentence);
        return new ConnectedMultiFieldsPhraseQueryBuilder(this.phraseContext, this.queryCustomizer, this.fieldContexts, this.queryContext);
    }

    @Override
    public PhraseMatchingContext boostedTo(float boost) {
        for (FieldContext fieldContext : this.getCurrentFieldContexts()) {
            fieldContext.getFieldCustomizer().boostedTo(boost);
        }
        return this;
    }

    private List<FieldContext> getCurrentFieldContexts() {
        return this.fieldContexts.subList(this.firstOfContext, this.fieldContexts.size());
    }

    @Override
    public PhraseMatchingContext ignoreAnalyzer() {
        for (FieldContext fieldContext : this.getCurrentFieldContexts()) {
            fieldContext.setIgnoreAnalyzer(true);
        }
        return this;
    }

    @Override
    public PhraseMatchingContext ignoreFieldBridge() {
        return this;
    }
}

