/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.v2.impl;

import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.query.dsl.v2.EntityContext;
import org.hibernate.search.query.dsl.v2.QueryBuilder;
import org.hibernate.search.query.dsl.v2.QueryContextBuilder;
import org.hibernate.search.query.dsl.v2.impl.ConnectedQueryBuilder;
import org.hibernate.search.query.dsl.v2.impl.QueryBuildingContext;
import org.hibernate.search.util.ScopedAnalyzer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectedQueryContextBuilder
implements QueryContextBuilder {
    private final SearchFactoryImplementor factory;

    public ConnectedQueryContextBuilder(SearchFactoryImplementor factory) {
        this.factory = factory;
    }

    @Override
    public EntityContext forEntity(Class<?> entityType) {
        return new HSearchEntityContext(entityType, this.factory);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class HSearchEntityContext
    implements EntityContext {
        private final ScopedAnalyzer queryAnalyzer = new ScopedAnalyzer();
        private final QueryBuildingContext context;

        public HSearchEntityContext(Class<?> entityType, SearchFactoryImplementor factory) {
            this.queryAnalyzer.setGlobalAnalyzer(factory.getAnalyzer(entityType));
            this.context = new QueryBuildingContext(factory, this.queryAnalyzer, entityType);
        }

        @Override
        public EntityContext overridesForField(String field, String analyzerName) {
            this.queryAnalyzer.addScopedAnalyzer(field, ConnectedQueryContextBuilder.this.factory.getAnalyzer(analyzerName));
            return this;
        }

        @Override
        public QueryBuilder get() {
            return new ConnectedQueryBuilder(this.context);
        }
    }
}

