/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.v2.impl;

import org.apache.lucene.search.Filter;
import org.hibernate.search.query.dsl.v2.TermMatchingContext;
import org.hibernate.search.query.dsl.v2.WildcardContext;
import org.hibernate.search.query.dsl.v2.impl.ConnectedTermMatchingContext;
import org.hibernate.search.query.dsl.v2.impl.QueryBuildingContext;
import org.hibernate.search.query.dsl.v2.impl.QueryCustomizer;
import org.hibernate.search.query.dsl.v2.impl.TermQueryContext;

class ConnectedWildcardContext
implements WildcardContext {
    private final QueryBuildingContext queryContext;
    private final QueryCustomizer queryCustomizer;
    private final TermQueryContext termContext;

    public ConnectedWildcardContext(QueryCustomizer queryCustomizer, QueryBuildingContext queryContext) {
        this.queryContext = queryContext;
        this.queryCustomizer = queryCustomizer;
        this.termContext = new TermQueryContext(TermQueryContext.Approximation.WILDCARD);
    }

    public TermMatchingContext onField(String field) {
        return new ConnectedTermMatchingContext(this.termContext, field, this.queryCustomizer, this.queryContext);
    }

    public WildcardContext boostedTo(float boost) {
        this.queryCustomizer.boostedTo(boost);
        return this;
    }

    public WildcardContext withConstantScore() {
        this.queryCustomizer.withConstantScore();
        return this;
    }

    public WildcardContext filteredBy(Filter filter) {
        this.queryCustomizer.filteredBy(filter);
        return this;
    }
}

