/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.impl;

import java.lang.reflect.Method;
import org.hibernate.annotations.common.util.ReflectHelper;
import org.hibernate.search.SearchException;
import org.hibernate.search.annotations.Factory;
import org.hibernate.search.cfg.SearchConfiguration;
import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.util.LoggerFactory;
import org.hibernate.search.util.ReflectionHelper;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SearchMappingBuilder {
    private static final Logger LOG = LoggerFactory.make();

    private SearchMappingBuilder() {
    }

    public static SearchMapping getSearchMapping(SearchConfiguration cfg) {
        Object modelMappingProperty = cfg.getProgrammaticMapping();
        if (modelMappingProperty == null) {
            modelMappingProperty = cfg.getProperties().get("hibernate.search.model_mapping");
        }
        if (modelMappingProperty == null) {
            return null;
        }
        SearchMapping mapping = null;
        Object programmaticConfig = modelMappingProperty;
        if (programmaticConfig instanceof SearchMapping) {
            mapping = (SearchMapping)programmaticConfig;
            return mapping;
        }
        Class<?> clazz = SearchMappingBuilder.getProgrammaticMappingClass(programmaticConfig);
        Method[] methods = clazz.getDeclaredMethods();
        int count = 0;
        for (Method method : methods) {
            if (!method.isAnnotationPresent(Factory.class)) continue;
            ++count;
            ReflectionHelper.setAccessible(method);
            mapping = SearchMappingBuilder.getNewInstanceOfSearchMapping(clazz, method);
        }
        SearchMappingBuilder.validateMappingFactoryDefinition(count, clazz);
        return mapping;
    }

    private static SearchMapping getNewInstanceOfSearchMapping(Class<?> clazz, Method method) {
        SearchMapping mapping = null;
        try {
            LOG.debug("invoking factory method [ {}.{} ] to get search mapping instance", (Object)clazz.getName(), (Object)method.getName());
            Object instance = clazz.newInstance();
            mapping = (SearchMapping)method.invoke(instance, new Object[0]);
        }
        catch (Exception e) {
            throw new SearchException("Unable to call the factory method: " + clazz.getName() + "." + method.getName(), e);
        }
        return mapping;
    }

    private static void validateMappingFactoryDefinition(int count, Class<?> factory) {
        if (count == 0) {
            throw new SearchException("No @Factory method defined for building programmatic api on " + factory);
        }
        if (count > 1) {
            throw new SearchException("Multiple @Factory methods defined. Only one factory method required. " + factory);
        }
    }

    private static Class<?> getProgrammaticMappingClass(Object programmaticConfig) {
        Class clazz = null;
        if (programmaticConfig instanceof String) {
            String className = (String)programmaticConfig;
            try {
                clazz = ReflectHelper.classForName((String)className, SearchMappingBuilder.class);
            }
            catch (ClassNotFoundException e) {
                throw new SearchException("Unable to find hibernate.search.model_mapping=" + className, e);
            }
        } else if (programmaticConfig instanceof Class) {
            clazz = (Class)programmaticConfig;
        } else {
            throw new SearchException("hibernate.search.model_mapping is of an unknown type: " + programmaticConfig.getClass());
        }
        if (clazz == null) {
            throw new SearchException("No programmatic factory defined");
        }
        return clazz;
    }
}

