/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.Work;
import org.hibernate.search.util.LoggerFactory;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkQueue {
    private static final Logger log = LoggerFactory.make();
    private List<Work> queue;
    private List<LuceneWork> sealedQueue;
    private boolean usedSealedData;
    private boolean sealedAndUnchanged;

    public WorkQueue(int size) {
        this.queue = new ArrayList<Work>(size);
    }

    private WorkQueue(List<Work> queue) {
        this.queue = queue;
    }

    public boolean isSealedAndUnchanged() {
        return this.sealedAndUnchanged;
    }

    public WorkQueue() {
        this(10);
    }

    public void add(Work work) {
        if (this.usedSealedData) {
            throw new AssertionFailure("Attempting to add a work in a used sealed queue");
        }
        this.sealedAndUnchanged = false;
        this.queue.add(work);
    }

    public List<Work> getQueue() {
        return this.queue;
    }

    public WorkQueue splitQueue() {
        WorkQueue subQueue = new WorkQueue(this.queue);
        this.queue = new ArrayList<Work>(this.queue.size());
        this.sealedAndUnchanged = false;
        return subQueue;
    }

    public List<LuceneWork> getSealedQueue() {
        if (this.sealedQueue == null) {
            throw new AssertionFailure("Access a Sealed WorkQueue which has not been sealed");
        }
        this.sealedAndUnchanged = false;
        return this.sealedQueue;
    }

    public void setSealedQueue(List<LuceneWork> sealedQueue) {
        this.sealedAndUnchanged = true;
        this.sealedQueue = sealedQueue;
    }

    public void clear() {
        this.queue.clear();
        this.sealedAndUnchanged = false;
        if (this.sealedQueue != null) {
            this.sealedQueue.clear();
        }
    }

    public int size() {
        return this.queue.size();
    }
}

