/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.cfg;

import java.lang.annotation.ElementType;
import java.util.HashMap;
import java.util.Map;
import org.apache.solr.analysis.TokenizerFactory;
import org.hibernate.search.analyzer.Discriminator;
import org.hibernate.search.cfg.AnalyzerDefMapping;
import org.hibernate.search.cfg.EntityDescriptor;
import org.hibernate.search.cfg.EntityMapping;
import org.hibernate.search.cfg.FullTextFilterDefMapping;
import org.hibernate.search.cfg.PropertyMapping;
import org.hibernate.search.cfg.ProvidedIdMapping;
import org.hibernate.search.cfg.SearchMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexedMapping {
    private final SearchMapping mapping;
    private final EntityDescriptor entity;
    private final Map<String, Object> indexed;
    private final EntityMapping entityMapping;

    public IndexedMapping(SearchMapping mapping, EntityDescriptor entity, EntityMapping entityMapping) {
        this.entityMapping = entityMapping;
        this.mapping = mapping;
        this.entity = entity;
        this.indexed = new HashMap<String, Object>();
        entity.setIndexed(this.indexed);
    }

    public EntityMapping indexName(String indexName) {
        this.indexed.put("index", indexName);
        return this.entityMapping;
    }

    public IndexedMapping similarity(Class<?> impl) {
        HashMap<String, Object> similarity = new HashMap<String, Object>(1);
        similarity.put("impl", impl);
        this.entity.setSimilariy(similarity);
        return this;
    }

    public IndexedMapping boost(float boost) {
        HashMap<String, Object> boostAnn = new HashMap<String, Object>();
        boostAnn.put("value", Float.valueOf(boost));
        this.entity.setBoost(boostAnn);
        return this;
    }

    public IndexedMapping analyzerDiscriminator(Class<? extends Discriminator> discriminator) {
        HashMap<String, Object> discriminatorAnn = new HashMap<String, Object>();
        discriminatorAnn.put("impl", discriminator);
        this.entity.setAnalyzerDiscriminator(discriminatorAnn);
        return this;
    }

    public FullTextFilterDefMapping fullTextFilterDef(String name, Class<?> impl) {
        return new FullTextFilterDefMapping(this.mapping, name, impl);
    }

    public PropertyMapping property(String name, ElementType type) {
        return new PropertyMapping(name, type, this.entity, this.mapping);
    }

    public AnalyzerDefMapping analyzerDef(String name, Class<? extends TokenizerFactory> tokenizerFactory) {
        return new AnalyzerDefMapping(name, tokenizerFactory, this.mapping);
    }

    public EntityMapping entity(Class<?> entityType) {
        return new EntityMapping(entityType, this.mapping);
    }

    public ProvidedIdMapping providedId() {
        return new ProvidedIdMapping(this.mapping, this.entity);
    }
}

