/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query;

import java.util.List;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.annotations.common.util.ReflectHelper;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.impl.CriteriaImpl;
import org.hibernate.search.SearchException;
import org.hibernate.search.engine.Loader;
import org.hibernate.search.engine.MultiClassesQueryLoader;
import org.hibernate.search.engine.QueryLoader;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.query.TimeoutManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectLoaderBuilder {
    private Criteria criteria;
    private List<Class<?>> targetedEntities;
    private SessionImplementor session;
    private SearchFactoryImplementor searchFactoryImplementor;
    private Set<Class<?>> indexedTargetedEntities;
    private TimeoutManager timeoutManager;

    public ObjectLoaderBuilder criteria(Criteria criteria) {
        this.criteria = criteria;
        return this;
    }

    public ObjectLoaderBuilder targetedEntities(List<Class<?>> targetedEntities) {
        this.targetedEntities = targetedEntities;
        return this;
    }

    public Loader buildLoader() {
        if (this.criteria != null) {
            return this.getCriteriaLoader();
        }
        if (this.targetedEntities.size() == 1) {
            return this.getSingleEntityLoader();
        }
        return this.getMultipleEntitiesLoader();
    }

    private Loader getMultipleEntitiesLoader() {
        MultiClassesQueryLoader multiClassesLoader = new MultiClassesQueryLoader();
        multiClassesLoader.init((Session)this.session, this.searchFactoryImplementor, this.timeoutManager);
        multiClassesLoader.setEntityTypes(this.indexedTargetedEntities);
        return multiClassesLoader;
    }

    private Loader getSingleEntityLoader() {
        QueryLoader queryLoader = new QueryLoader();
        queryLoader.init((Session)this.session, this.searchFactoryImplementor, this.timeoutManager);
        queryLoader.setEntityType(this.targetedEntities.iterator().next());
        return queryLoader;
    }

    private Loader getCriteriaLoader() {
        Class entityType;
        if (this.targetedEntities.size() > 1) {
            throw new SearchException("Cannot mix criteria and multiple entity types");
        }
        Class clazz = entityType = this.targetedEntities.size() == 0 ? null : this.targetedEntities.iterator().next();
        if (this.criteria instanceof CriteriaImpl) {
            String targetEntity = ((CriteriaImpl)this.criteria).getEntityOrClassName();
            if (entityType != null && !entityType.getName().equals(targetEntity)) {
                throw new SearchException("Criteria query entity should match query entity");
            }
            try {
                entityType = ReflectHelper.classForName((String)targetEntity);
            }
            catch (ClassNotFoundException e) {
                throw new SearchException("Unable to load entity class from criteria: " + targetEntity, e);
            }
        }
        QueryLoader queryLoader = new QueryLoader();
        queryLoader.init((Session)this.session, this.searchFactoryImplementor, this.timeoutManager);
        queryLoader.setEntityType(entityType);
        queryLoader.setCriteria(this.criteria);
        return queryLoader;
    }

    public ObjectLoaderBuilder session(SessionImplementor session) {
        this.session = session;
        return this;
    }

    public ObjectLoaderBuilder searchFactory(SearchFactoryImplementor searchFactoryImplementor) {
        this.searchFactoryImplementor = searchFactoryImplementor;
        return this;
    }

    public ObjectLoaderBuilder indexedTargetedEntities(Set<Class<?>> indexedTargetedEntities) {
        this.indexedTargetedEntities = indexedTargetedEntities;
        return this;
    }

    public ObjectLoaderBuilder timeoutManager(TimeoutManager timeoutManager) {
        this.timeoutManager = timeoutManager;
        return this;
    }
}

