/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query;

import java.sql.SQLException;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.search.Query;
import org.hibernate.QueryTimeoutException;

public class TimeoutManager {
    private Long timeout;
    private boolean bestEffort;
    private long start;
    boolean timedOut = false;
    private Query luceneQuery;

    public void start(Query luceneQuery) {
        if (this.timeout == null) {
            return;
        }
        this.luceneQuery = luceneQuery;
        this.start = System.nanoTime();
    }

    public Long getTimeoutLeftInMilliseconds() {
        return this.getTimeoutLeft(1000000L);
    }

    public Long getTimeoutLeftInSeconds() {
        return this.getTimeoutLeft(1000000000L);
    }

    private Long getTimeoutLeft(long factor) {
        if (this.timeout == null) {
            return null;
        }
        long left = this.timeout - (System.nanoTime() - this.start);
        if (left % factor == 0L) {
            return left / factor;
        }
        return left / factor + 1L;
    }

    public boolean isBestEffort() {
        return this.bestEffort;
    }

    public void setBestEffort(boolean bestEffort) {
        this.bestEffort = bestEffort;
    }

    public boolean isTimedOut() {
        if (this.timeout == null) {
            return false;
        }
        if (this.timedOut) {
            return true;
        }
        long elapsedTime = System.nanoTime() - this.start;
        boolean bl = this.timedOut = elapsedTime > this.timeout;
        if (!this.bestEffort) {
            throw new QueryTimeoutException("Full-text query took longer than expected (in microsecond): " + TimeUnit.NANOSECONDS.toMicros(elapsedTime), (SQLException)null, this.luceneQuery.toString());
        }
        return this.timedOut;
    }

    public void stop() {
        this.timeout = null;
    }

    public void setTimeout(long timeout, TimeUnit timeUnit) {
        this.timeout = timeUnit.toNanos(timeout);
    }
}

