/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.search.engine.AbstractLoader;
import org.hibernate.search.engine.DocumentBuilderIndexedEntity;
import org.hibernate.search.engine.EntityInfo;
import org.hibernate.search.engine.ObjectLoaderHelper;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.query.TimeoutManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiClassesQueryLoader
extends AbstractLoader {
    private Session session;
    private SearchFactoryImplementor searchFactoryImplementor;
    private List<RootEntityMetadata> entityMatadata;
    private TimeoutManager timeoutManager;

    @Override
    public void init(Session session, SearchFactoryImplementor searchFactoryImplementor, TimeoutManager timeoutManager) {
        super.init(session, searchFactoryImplementor);
        this.session = session;
        this.searchFactoryImplementor = searchFactoryImplementor;
        this.timeoutManager = timeoutManager;
    }

    public void setEntityTypes(Set<Class<?>> entityTypes) {
        ArrayList safeEntityTypes = new ArrayList();
        if (entityTypes.size() == 0) {
            for (Map.Entry<Class<?>, DocumentBuilderIndexedEntity<?>> entry : this.searchFactoryImplementor.getDocumentBuildersIndexedEntities().entrySet()) {
                if (!entry.getValue().isRoot()) continue;
                safeEntityTypes.add(entry.getKey());
            }
        } else {
            safeEntityTypes.addAll(entityTypes);
        }
        this.entityMatadata = new ArrayList<RootEntityMetadata>(safeEntityTypes.size());
        for (Class clazz : safeEntityTypes) {
            this.entityMatadata.add(new RootEntityMetadata(clazz, this.searchFactoryImplementor, this.session));
        }
    }

    @Override
    public Object executeLoad(EntityInfo entityInfo) {
        Object result = ObjectLoaderHelper.load(entityInfo, this.session);
        this.timeoutManager.isTimedOut();
        return result;
    }

    @Override
    public List executeLoad(EntityInfo ... entityInfos) {
        if (entityInfos.length == 0) {
            return Collections.EMPTY_LIST;
        }
        if (entityInfos.length == 1) {
            Object entity = this.load(entityInfos[0]);
            if (entity == null) {
                return Collections.EMPTY_LIST;
            }
            ArrayList<Object> list = new ArrayList<Object>(1);
            list.add(entity);
            return list;
        }
        HashMap<RootEntityMetadata, ArrayList<EntityInfo>> entityinfoBuckets = new HashMap<RootEntityMetadata, ArrayList<EntityInfo>>(this.entityMatadata.size());
        for (EntityInfo entityInfo : entityInfos) {
            boolean found = false;
            for (RootEntityMetadata rootEntityInfo : this.entityMatadata) {
                if (rootEntityInfo.rootEntity != entityInfo.clazz && !rootEntityInfo.mappedSubclasses.contains(entityInfo.clazz)) continue;
                ArrayList<EntityInfo> bucket = (ArrayList<EntityInfo>)entityinfoBuckets.get(rootEntityInfo);
                if (bucket == null) {
                    bucket = new ArrayList<EntityInfo>();
                    entityinfoBuckets.put(rootEntityInfo, bucket);
                }
                bucket.add(entityInfo);
                found = true;
                break;
            }
            if (found) continue;
            throw new AssertionFailure("Could not find root entity for " + entityInfo.clazz);
        }
        for (Map.Entry entry : entityinfoBuckets.entrySet()) {
            RootEntityMetadata key = (RootEntityMetadata)entry.getKey();
            List value = (List)entry.getValue();
            EntityInfo[] bucketEntityInfos = value.toArray(new EntityInfo[value.size()]);
            ObjectLoaderHelper.initializeObjects(bucketEntityInfos, key.criteria, key.rootEntity, this.searchFactoryImplementor, this.timeoutManager);
            this.timeoutManager.isTimedOut();
        }
        return ObjectLoaderHelper.returnAlreadyLoadedObjectsInCorrectOrder(entityInfos, this.session);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RootEntityMetadata {
        public final Class<?> rootEntity;
        public final Set<Class<?>> mappedSubclasses;
        private final Criteria criteria;

        RootEntityMetadata(Class<?> rootEntity, SearchFactoryImplementor searchFactoryImplementor, Session session) {
            this.rootEntity = rootEntity;
            DocumentBuilderIndexedEntity<?> provider = searchFactoryImplementor.getDocumentBuilderIndexedEntity(rootEntity);
            if (provider == null) {
                throw new AssertionFailure("Provider not found for class: " + rootEntity);
            }
            this.mappedSubclasses = provider.getMappedSubclasses();
            this.criteria = session.createCriteria(rootEntity);
        }
    }
}

