/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.search.SearchException;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.builtin.NumericFieldBridge;
import org.hibernate.search.bridge.util.NumericFieldUtils;
import org.hibernate.search.engine.DocumentBuilderIndexedEntity;
import org.hibernate.search.query.dsl.TermTermination;
import org.hibernate.search.query.dsl.impl.FieldContext;
import org.hibernate.search.query.dsl.impl.Helper;
import org.hibernate.search.query.dsl.impl.QueryBuildingContext;
import org.hibernate.search.query.dsl.impl.QueryCustomizer;
import org.hibernate.search.query.dsl.impl.TermQueryContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectedMultiFieldsTermQueryBuilder
implements TermTermination {
    private final Object value;
    private final QueryCustomizer queryCustomizer;
    private final TermQueryContext termContext;
    private final List<FieldContext> fieldContexts;
    private final QueryBuildingContext queryContext;

    public ConnectedMultiFieldsTermQueryBuilder(TermQueryContext termContext, Object value, List<FieldContext> fieldContexts, QueryCustomizer queryCustomizer, QueryBuildingContext queryContext) {
        this.termContext = termContext;
        this.value = value;
        this.queryContext = queryContext;
        this.queryCustomizer = queryCustomizer;
        this.fieldContexts = fieldContexts;
    }

    @Override
    public Query createQuery() {
        int size = this.fieldContexts.size();
        if (size == 1) {
            return this.queryCustomizer.setWrappedQuery(this.createQuery(this.fieldContexts.get(0))).createQuery();
        }
        BooleanQuery aggregatedFieldsQuery = new BooleanQuery();
        for (FieldContext fieldContext : this.fieldContexts) {
            aggregatedFieldsQuery.add(this.createQuery(fieldContext), BooleanClause.Occur.SHOULD);
        }
        return this.queryCustomizer.setWrappedQuery((Query)aggregatedFieldsQuery).createQuery();
    }

    public Query createQuery(FieldContext fieldContext) {
        Query perFieldQuery;
        String text;
        DocumentBuilderIndexedEntity<?> documentBuilder = Helper.getDocumentBuilder(this.queryContext);
        FieldBridge fieldBridge = documentBuilder.getBridge(fieldContext.getField());
        if (fieldBridge instanceof NumericFieldBridge) {
            return NumericFieldUtils.createExactMatchQuery(fieldContext.getField(), this.value);
        }
        String string = text = fieldContext.isIgnoreFieldBridge() ? this.value.toString() : documentBuilder.objectToString(fieldContext.getField(), this.value);
        if (fieldContext.isIgnoreAnalyzer()) {
            perFieldQuery = this.createTermQuery(fieldContext, text);
        } else {
            List<String> terms;
            try {
                terms = this.getAllTermsFromText(fieldContext.getField(), text, this.queryContext.getQueryAnalyzer());
            }
            catch (IOException e) {
                throw new AssertionFailure("IO exception while reading String stream??", (Throwable)e);
            }
            if (terms.size() == 0) {
                throw new SearchException("try to search with an empty string: " + fieldContext.getField());
            }
            if (terms.size() == 1) {
                perFieldQuery = this.createTermQuery(fieldContext, terms.get(0));
            } else {
                BooleanQuery booleanQuery = new BooleanQuery();
                for (String localTerm : terms) {
                    Query termQuery = this.createTermQuery(fieldContext, localTerm);
                    booleanQuery.add(termQuery, BooleanClause.Occur.SHOULD);
                }
                perFieldQuery = booleanQuery;
            }
        }
        return fieldContext.getFieldCustomizer().setWrappedQuery(perFieldQuery).createQuery();
    }

    private Query createTermQuery(FieldContext fieldContext, String term) {
        TermQuery query;
        String fieldName = fieldContext.getField();
        switch (this.termContext.getApproximation()) {
            case EXACT: {
                query = new TermQuery(new Term(fieldName, term));
                break;
            }
            case WILDCARD: {
                query = new WildcardQuery(new Term(fieldName, term));
                break;
            }
            case FUZZY: {
                query = new FuzzyQuery(new Term(fieldName, term), this.termContext.getThreshold(), this.termContext.getPrefixLength());
                break;
            }
            default: {
                throw new AssertionFailure("Unknown approximation: " + (Object)((Object)this.termContext.getApproximation()));
            }
        }
        return query;
    }

    private List<String> getAllTermsFromText(String fieldName, String localText, Analyzer analyzer) throws IOException {
        ArrayList<String> terms = new ArrayList<String>();
        if (this.termContext.getApproximation() == TermQueryContext.Approximation.WILDCARD) {
            terms.add(localText);
        } else {
            terms = Helper.getAllTermsFromText(fieldName, localText, analyzer);
        }
        return terms;
    }
}

