/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import org.hibernate.util.LRUMap;

public class SoftLimitMRUCache
implements Serializable {
    public static final int DEFAULT_STRONG_REF_COUNT = 128;
    public static final int DEFAULT_SOFT_REF_COUNT = 2048;
    private final int strongRefCount;
    private final int softRefCount;
    private transient LRUMap strongRefCache;
    private transient LRUMap softRefCache;
    private transient ReferenceQueue referenceQueue;

    public SoftLimitMRUCache() {
        this(128, 2048);
    }

    public SoftLimitMRUCache(int strongRefCount, int softRefCount) {
        if (strongRefCount < 1 || softRefCount < 1) {
            throw new IllegalArgumentException("Reference counts must be greater than zero");
        }
        if (strongRefCount > softRefCount) {
            throw new IllegalArgumentException("Strong reference count cannot exceed soft reference count");
        }
        this.strongRefCount = strongRefCount;
        this.softRefCount = softRefCount;
        this.init();
    }

    public synchronized Object get(Object key) {
        Object refValue;
        if (key == null) {
            throw new NullPointerException("Key to get cannot be null");
        }
        this.clearObsoleteReferences();
        SoftReference ref = (SoftReference)this.softRefCache.get(key);
        if (ref != null && (refValue = ref.get()) != null) {
            this.strongRefCache.put(key, refValue);
            return refValue;
        }
        return null;
    }

    public synchronized Object put(Object key, Object value) {
        if (key == null || value == null) {
            throw new NullPointerException(this.getClass().getName() + "does not support null key [" + key + "] or value [" + value + "]");
        }
        this.clearObsoleteReferences();
        this.strongRefCache.put(key, value);
        SoftReference ref = (SoftReference)this.softRefCache.put(key, (Object)new KeyedSoftReference(key, value, this.referenceQueue));
        return ref != null ? ref.get() : null;
    }

    public synchronized int size() {
        this.clearObsoleteReferences();
        return this.strongRefCache.size();
    }

    public synchronized int softSize() {
        this.clearObsoleteReferences();
        return this.softRefCache.size();
    }

    public synchronized void clear() {
        this.strongRefCache.clear();
        this.softRefCache.clear();
    }

    private void init() {
        this.strongRefCache = new LRUMap(this.strongRefCount);
        this.softRefCache = new LRUMap(this.softRefCount);
        this.referenceQueue = new ReferenceQueue();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.init();
    }

    private void clearObsoleteReferences() {
        KeyedSoftReference obsoleteRef;
        while ((obsoleteRef = (KeyedSoftReference)this.referenceQueue.poll()) != null) {
            Object key = obsoleteRef.getKey();
            this.softRefCache.remove(key);
        }
    }

    private static class KeyedSoftReference
    extends SoftReference {
        private final Object key;

        private KeyedSoftReference(Object key, Object value, ReferenceQueue q) {
            super(value, q);
            this.key = key;
        }

        private Object getKey() {
            return this.key;
        }
    }
}

