/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend;

import java.io.IOException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.SimpleAnalyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.search.Similarity;
import org.hibernate.search.backend.LuceneIndexingParameters;
import org.hibernate.search.backend.impl.lucene.overrides.ConcurrentMergeScheduler;
import org.hibernate.search.engine.DocumentBuilderIndexedEntity;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.exception.ErrorContext;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.exception.impl.ErrorContextBuilder;
import org.hibernate.search.exception.impl.SingleErrorContext;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.store.optimization.OptimizerStrategy;
import org.hibernate.search.util.LoggerFactory;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Workspace {
    private static final Logger log = LoggerFactory.make();
    private static final Analyzer SIMPLE_ANALYZER = new SimpleAnalyzer();
    private static final IndexWriter.MaxFieldLength maxFieldLength = new IndexWriter.MaxFieldLength(10000);
    private final SearchFactoryImplementor searchFactoryImplementor;
    private final DirectoryProvider<?> directoryProvider;
    private final OptimizerStrategy optimizerStrategy;
    private final ReentrantLock lock;
    private final Set<Class<?>> entitiesInDirectory;
    private final LuceneIndexingParameters indexingParams;
    private final Similarity similarity;
    private final ErrorHandler errorHandler;
    private IndexWriter writer;
    private final AtomicLong operations = new AtomicLong(0L);

    public Workspace(WorkerBuildContext context, DirectoryProvider<?> provider, ErrorHandler errorHandler) {
        this.searchFactoryImplementor = context.getUninitializedSearchFactory();
        this.directoryProvider = provider;
        this.optimizerStrategy = context.getOptimizerStrategy(this.directoryProvider);
        this.entitiesInDirectory = context.getClassesInDirectoryProvider(provider);
        this.indexingParams = context.getIndexingParameters(this.directoryProvider);
        this.lock = context.getDirectoryProviderLock(provider);
        this.similarity = context.getSimilarity(this.directoryProvider);
        this.errorHandler = errorHandler;
    }

    public <T> DocumentBuilderIndexedEntity<T> getDocumentBuilder(Class<T> entity) {
        return this.searchFactoryImplementor.getDocumentBuilderIndexedEntity(entity);
    }

    public Analyzer getAnalyzer(String name) {
        return this.searchFactoryImplementor.getAnalyzer(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void optimizerPhase() {
        this.lock.lock();
        try {
            OptimizerStrategy optimizerStrategy = this.optimizerStrategy;
            synchronized (optimizerStrategy) {
                this.optimizerStrategy.addTransaction(this.operations.getAndSet(0L));
                this.optimizerStrategy.optimize(this);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void optimize() {
        this.lock.lock();
        try {
            OptimizerStrategy optimizerStrategy = this.optimizerStrategy;
            synchronized (optimizerStrategy) {
                this.optimizerStrategy.optimizationForced();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public synchronized IndexWriter getIndexWriter(boolean batchmode, ErrorContextBuilder errorContextBuilder) {
        if (this.writer != null) {
            return this.writer;
        }
        try {
            this.writer = new IndexWriter(this.directoryProvider.getDirectory(), SIMPLE_ANALYZER, false, maxFieldLength);
            this.indexingParams.applyToWriter(this.writer, batchmode);
            this.writer.setSimilarity(this.similarity);
            ConcurrentMergeScheduler mergeScheduler = new ConcurrentMergeScheduler(this.errorHandler);
            this.writer.setMergeScheduler((MergeScheduler)mergeScheduler);
            log.trace("IndexWriter opened");
        }
        catch (IOException ioe) {
            this.writer = null;
            this.handleIOException(ioe, errorContextBuilder);
        }
        return this.writer;
    }

    public IndexWriter getIndexWriter(boolean batchmode) {
        return this.getIndexWriter(batchmode, null);
    }

    public synchronized void commitIndexWriter(ErrorContextBuilder errorContextBuilder) {
        if (this.writer != null) {
            try {
                this.writer.commit();
                log.trace("Index changes commited.");
            }
            catch (IOException ioe) {
                this.handleIOException(ioe, errorContextBuilder);
            }
        }
    }

    public synchronized void commitIndexWriter() {
        this.commitIndexWriter(null);
    }

    public synchronized void closeIndexWriter() {
        IndexWriter toClose = this.writer;
        this.writer = null;
        if (toClose != null) {
            try {
                toClose.close();
                log.trace("IndexWriter closed");
            }
            catch (IOException ioe) {
                this.handleIOException(ioe, null);
            }
        }
    }

    public void incrementModificationCounter(int modCount) {
        this.operations.addAndGet(modCount);
    }

    public Set<Class<?>> getEntitiesInDirectory() {
        return this.entitiesInDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void forceLockRelease() {
        log.warn("going to force release of the IndexWriter lock");
        try {
            try {
                if (this.writer != null) {
                    this.writer.close();
                    log.trace("IndexWriter closed");
                }
            }
            finally {
                this.writer = null;
                IndexWriter.unlock(this.directoryProvider.getDirectory());
            }
        }
        catch (IOException ioe) {
            this.handleIOException(ioe, null);
        }
    }

    private void handleIOException(IOException ioe, ErrorContextBuilder errorContextBuilder) {
        if (log.isTraceEnabled()) {
            log.trace("going to handle IOException", (Throwable)ioe);
        }
        ErrorContext errorContext = errorContextBuilder != null ? errorContextBuilder.errorThatOccurred(ioe).createErrorContext() : new SingleErrorContext(ioe);
        this.errorHandler.handle(errorContext);
    }
}

