/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.search.SearchException;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.PurgeAllLuceneWork;
import org.hibernate.search.backend.Work;
import org.hibernate.search.backend.WorkType;
import org.hibernate.search.engine.AbstractDocumentBuilder;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.util.HibernateHelper;
import org.hibernate.search.util.LoggerFactory;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkPlan {
    private static final Logger log = LoggerFactory.make();
    private final HashMap<Class<?>, PerClassWork<?>> byClass = new HashMap();
    private final SearchFactoryImplementor searchFactoryImplementor;
    private int approximateWorkQueueSize = 0;

    public WorkPlan(SearchFactoryImplementor searchFactoryImplementor) {
        this.searchFactoryImplementor = searchFactoryImplementor;
    }

    public <T> void addWork(Work<T> work) {
        ++this.approximateWorkQueueSize;
        Class<T> entityClass = HibernateHelper.getClassFromWork(work);
        PerClassWork classWork = this.getClassWork(entityClass);
        classWork.addWork(work);
    }

    public void clear() {
        this.byClass.clear();
        this.approximateWorkQueueSize = 0;
    }

    public int size() {
        return this.approximateWorkQueueSize;
    }

    private <T> PerClassWork getClassWork(Class<T> entityClass) {
        PerClassWork<Object> classWork = this.byClass.get(entityClass);
        if (classWork == null) {
            classWork = new PerClassWork<T>(entityClass);
            this.byClass.put(entityClass, classWork);
        }
        return classWork;
    }

    public void processContainedInAndPrepareExecution() {
        for (PerClassWork<?> perClassWork : this.byClass.values()) {
            perClassWork.processContainedInAndPrepareExecution();
        }
    }

    <T> void recurseContainedIn(T value) {
        Class<T> entityClass = HibernateHelper.getClass(value);
        PerClassWork classWork = this.getClassWork(entityClass);
        classWork.recurseContainedIn(value);
    }

    public List<LuceneWork> getPlannedLuceneWork() {
        ArrayList<LuceneWork> luceneQueue = new ArrayList<LuceneWork>();
        for (PerClassWork<?> perClassWork : this.byClass.values()) {
            perClassWork.enqueueLuceneWork(luceneQueue);
        }
        return luceneQueue;
    }

    private static <T> AbstractDocumentBuilder<T> getEntityBuilder(SearchFactoryImplementor searchFactoryImplementor, Class entityClass) {
        AbstractDocumentBuilder entityBuilder = searchFactoryImplementor.getDocumentBuilderIndexedEntity(entityClass);
        if (entityBuilder == null && (entityBuilder = searchFactoryImplementor.getDocumentBuilderContainedEntity(entityClass)) == null) {
            throw new SearchException("Unable to perform work. Entity Class is not @Indexed nor hosts @ContainedIn: " + entityClass);
        }
        return entityBuilder;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PerEntityWork<T> {
        private T entity;
        private boolean delete = false;
        private boolean add = false;
        private boolean batch = false;
        private boolean containedInProcessed = false;

        private PerEntityWork(T entity) {
            this.entity = entity;
            this.delete = true;
            this.add = true;
            this.containedInProcessed = true;
        }

        private PerEntityWork(Work<T> work) {
            this.entity = work.getEntity();
            WorkType type = work.getType();
            switch (type) {
                case ADD: {
                    this.add = true;
                    break;
                }
                case DELETE: 
                case PURGE: {
                    this.delete = true;
                    break;
                }
                case COLLECTION: 
                case UPDATE: {
                    this.delete = true;
                    this.add = true;
                    break;
                }
                case INDEX: {
                    this.add = true;
                    this.delete = true;
                    this.batch = true;
                    break;
                }
                default: {
                    throw new SearchException("unexpected state:" + (Object)((Object)type));
                }
            }
        }

        public void addWork(Work<T> work) {
            this.entity = work.getEntity();
            WorkType type = work.getType();
            switch (type) {
                case INDEX: {
                    this.batch = true;
                }
                case UPDATE: {
                    if (this.add && !this.delete) break;
                    this.add = true;
                    this.delete = true;
                    break;
                }
                case ADD: {
                    this.add = true;
                    break;
                }
                case DELETE: 
                case PURGE: {
                    if (this.add && !this.delete) {
                        this.add = false;
                        break;
                    }
                    this.add = false;
                    this.delete = true;
                    break;
                }
                case COLLECTION: {
                    if (this.add || this.delete) break;
                    this.add = true;
                    this.delete = true;
                    break;
                }
                default: {
                    throw new SearchException("unexpected state:" + (Object)((Object)type));
                }
            }
        }

        public void enqueueLuceneWork(Class<T> entityClass, Serializable indexingId, AbstractDocumentBuilder<T> entityBuilder, List<LuceneWork> luceneQueue) {
            if (this.add || this.delete) {
                entityBuilder.addWorkToQueue(entityClass, this.entity, indexingId, this.delete, this.add, this.batch, luceneQueue);
            }
        }

        public void processContainedIn(AbstractDocumentBuilder<T> entityBuilder, WorkPlan workplan) {
            if (!this.containedInProcessed) {
                this.containedInProcessed = true;
                if (this.add || this.delete) {
                    entityBuilder.appendContainedInWorkForInstance(this.entity, workplan);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PerClassWork<T> {
        private final HashMap<Serializable, PerEntityWork<T>> entityById = new HashMap();
        private boolean purgeAll = false;
        private final Class<T> entityClass;
        private final AbstractDocumentBuilder<T> documentBuilder;

        PerClassWork(Class<T> clazz) {
            this.entityClass = clazz;
            this.documentBuilder = WorkPlan.getEntityBuilder(WorkPlan.this.searchFactoryImplementor, clazz);
        }

        public void addWork(Work<T> work) {
            if (work.getType() == WorkType.PURGE_ALL) {
                this.entityById.clear();
                this.purgeAll = true;
            } else {
                Serializable id = this.extractProperId(work);
                PerEntityWork<T> entityWork = this.entityById.get(id);
                if (entityWork == null) {
                    entityWork = new PerEntityWork(work);
                    this.entityById.put(id, entityWork);
                }
                entityWork.addWork(work);
            }
        }

        private Serializable extractProperId(Work<T> work) {
            T entity = work.getEntity();
            if (entity == null || this.documentBuilder.requiresProvidedId()) {
                return work.getId();
            }
            return this.documentBuilder.getId(entity);
        }

        public void enqueueLuceneWork(List<LuceneWork> luceneQueue) {
            Set<Map.Entry<Serializable, PerEntityWork<T>>> entityInstances = this.entityById.entrySet();
            if (this.purgeAll) {
                luceneQueue.add(new PurgeAllLuceneWork(this.entityClass));
            }
            for (Map.Entry<Serializable, PerEntityWork<T>> entry : entityInstances) {
                Serializable indexingId = entry.getKey();
                PerEntityWork<T> perEntityWork = entry.getValue();
                perEntityWork.enqueueLuceneWork(this.entityClass, indexingId, this.documentBuilder, luceneQueue);
            }
        }

        public void processContainedInAndPrepareExecution() {
            Map.Entry[] entityInstancesFrozenView = new Map.Entry[this.entityById.size()];
            for (Map.Entry entry : entityInstancesFrozenView = this.entityById.entrySet().toArray(entityInstancesFrozenView)) {
                PerEntityWork perEntityWork = (PerEntityWork)entry.getValue();
                perEntityWork.processContainedIn(this.documentBuilder, WorkPlan.this);
            }
        }

        void recurseContainedIn(T value) {
            if (this.documentBuilder.requiresProvidedId()) {
                log.warn("@ContainedIn is pointing to an entity having @ProvidedId. This is not supported, indexing of contained in entities will be skipped.indexed data of the embedded object might become out of date in objects of type " + HibernateHelper.getClass(value));
            } else {
                Serializable extractedId = this.documentBuilder.getId(value);
                if (extractedId != null) {
                    PerEntityWork<T> entityWork = this.entityById.get(extractedId);
                    if (entityWork == null) {
                        entityWork = new PerEntityWork(value);
                        this.entityById.put(extractedId, entityWork);
                        this.documentBuilder.appendContainedInWorkForInstance(value, WorkPlan.this);
                    }
                } else {
                    this.documentBuilder.appendContainedInWorkForInstance(value, WorkPlan.this);
                }
            }
        }
    }
}

