/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.bridge.util;

import org.apache.lucene.document.Document;
import org.hibernate.search.bridge.StringBridge;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.bridge.util.ContextualExceptionBridge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextualException2WayBridge
extends ContextualExceptionBridge
implements TwoWayFieldBridge {
    private TwoWayFieldBridge delegate;
    private StringBridge stringBridge;

    public ContextualException2WayBridge setFieldBridge(TwoWayFieldBridge delegate) {
        super.setFieldBridge(delegate);
        this.delegate = delegate;
        this.stringBridge = null;
        return this;
    }

    @Override
    public ContextualException2WayBridge setClass(Class<?> clazz) {
        super.setClass(clazz);
        return this;
    }

    @Override
    public ContextualException2WayBridge setFieldName(String fieldName) {
        super.setFieldName(fieldName);
        return this;
    }

    @Override
    public Object get(String name, Document document) {
        try {
            return this.delegate.get(name, document);
        }
        catch (Exception e) {
            throw this.buildBridgeException(e, "get");
        }
    }

    @Override
    public String objectToString(Object object) {
        try {
            if (this.delegate != null) {
                return this.delegate.objectToString(object);
            }
            return this.stringBridge.objectToString(object);
        }
        catch (Exception e) {
            throw this.buildBridgeException(e, "objectToString");
        }
    }

    @Override
    public ContextualException2WayBridge pushMethod(String name) {
        super.pushMethod(name);
        return this;
    }

    @Override
    public ContextualException2WayBridge popMethod() {
        super.popMethod();
        return this;
    }

    public ContextualException2WayBridge setStringBridge(StringBridge bridge) {
        this.stringBridge = bridge;
        this.delegate = null;
        return this;
    }
}

