/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.cfg;

import java.lang.annotation.ElementType;
import java.util.HashMap;
import java.util.Map;
import org.apache.solr.analysis.TokenizerFactory;
import org.hibernate.search.cfg.AnalyzerDefMapping;
import org.hibernate.search.cfg.EntityDescriptor;
import org.hibernate.search.cfg.EntityMapping;
import org.hibernate.search.cfg.FieldMapping;
import org.hibernate.search.cfg.PropertyDescriptor;
import org.hibernate.search.cfg.PropertyMapping;
import org.hibernate.search.cfg.SearchMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentIdMapping {
    private final SearchMapping mapping;
    private final EntityDescriptor entity;
    private final PropertyDescriptor property;
    private final Map<String, Object> documentId = new HashMap<String, Object>();

    public DocumentIdMapping(PropertyDescriptor property, EntityDescriptor entity, SearchMapping mapping) {
        this.mapping = mapping;
        this.entity = entity;
        this.property = property;
        property.setDocumentId(this.documentId);
    }

    public DocumentIdMapping name(String fieldName) {
        this.documentId.put("name", fieldName);
        return this;
    }

    public FieldMapping field() {
        return new FieldMapping(this.property, this.entity, this.mapping);
    }

    public PropertyMapping property(String name, ElementType type) {
        return new PropertyMapping(name, type, this.entity, this.mapping);
    }

    public AnalyzerDefMapping analyzerDef(String name, Class<? extends TokenizerFactory> tokenizerFactory) {
        return new AnalyzerDefMapping(name, tokenizerFactory, this.mapping);
    }

    public EntityMapping entity(Class<?> entityType) {
        return new EntityMapping(entityType, this.mapping);
    }
}

