/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Scorer;
import org.hibernate.search.query.FieldCacheContainer;
import org.hibernate.search.query.dsl.impl.DiscreteFacetRequest;
import org.hibernate.search.query.dsl.impl.RangeFacetRequest;
import org.hibernate.search.query.facet.Facet;
import org.hibernate.search.query.facet.FacetRange;
import org.hibernate.search.query.facet.FacetRequest;
import org.hibernate.search.query.facet.FacetResult;
import org.hibernate.search.query.facet.FacetSortOrder;
import org.hibernate.search.util.CollectionHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacetCollector
extends Collector {
    private final Collector delegate;
    private final FacetRequest facetRequest;
    private final FieldCacheContainer fieldCache;
    private final FacetCounter facetCounts;
    private boolean initialised = false;

    public FacetCollector(Collector delegate, FacetRequest facetRequest) {
        this.delegate = delegate;
        this.facetRequest = facetRequest;
        this.facetCounts = this.createFacetCounter(facetRequest);
        this.fieldCache = new FieldCacheContainer();
    }

    public void setNextReader(IndexReader reader, int docBase) throws IOException {
        if (!this.initialised) {
            this.initialiseCollector(reader);
        }
        this.initialiseFieldCaches(reader);
        this.delegate.setNextReader(reader, docBase);
    }

    public void collect(int doc) throws IOException {
        if (this.fieldCache.containsCacheArray(this.facetRequest.getFieldCacheType())) {
            Object value = this.fieldCache.getCacheValue(this.facetRequest.getFieldCacheType(), doc);
            this.facetCounts.countValue(value);
        }
        this.delegate.collect(doc);
    }

    public void setScorer(Scorer scorer) throws IOException {
        this.delegate.setScorer(scorer);
    }

    public boolean acceptsDocsOutOfOrder() {
        return this.delegate.acceptsDocsOutOfOrder();
    }

    public FacetResult getFacetResult() {
        List<Facet> facetList = this.createSortedFacetList(this.facetCounts, this.facetRequest.getSort(), this.facetRequest.includeZeroCounts());
        return new FacetResult(this.facetRequest.getName(), this.facetRequest.getFieldName(), facetList);
    }

    private List<Facet> createSortedFacetList(FacetCounter counter, FacetSortOrder sort, boolean includeZeroCounts) {
        ArrayList<Facet> facetList = CollectionHelper.newArrayList();
        for (Map.Entry<String, Integer> countEntry : counter.getCounts().entrySet()) {
            Facet facet = new Facet(countEntry.getKey(), countEntry.getValue());
            if (!includeZeroCounts && facet.getCount() == 0) continue;
            facetList.add(facet);
        }
        Collections.sort(facetList, new FacetComparator(sort));
        return facetList;
    }

    private void initialiseCollector(IndexReader reader) throws IOException {
        if (this.facetRequest.includeZeroCounts() && this.facetRequest instanceof DiscreteFacetRequest) {
            this.initFacetCounts(reader);
        }
        this.initialised = true;
    }

    private void initialiseFieldCaches(IndexReader reader) throws IOException {
        String fieldName;
        Collection existingFieldNames = reader.getFieldNames(IndexReader.FieldOption.ALL);
        if (existingFieldNames.contains(fieldName = this.facetRequest.getFieldName())) {
            this.fieldCache.storeCacheArray(reader, this.facetRequest.getFieldName(), this.facetRequest.getFieldCacheType());
        }
    }

    private <N extends Number> FacetCounter createFacetCounter(FacetRequest request) {
        if (request instanceof DiscreteFacetRequest) {
            return new SimpleFacetCounter();
        }
        if (request instanceof RangeFacetRequest) {
            RangeFacetRequest rangeFacetRequest = (RangeFacetRequest)request;
            return new RangeFacetCounter(rangeFacetRequest);
        }
        throw new IllegalArgumentException("Unsupported cache type");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initFacetCounts(IndexReader reader) throws IOException {
        String fieldName = this.facetRequest.getFieldName();
        TermEnum terms = reader.terms(new Term(fieldName, ""));
        try {
            while (fieldName.equals(terms.term().field())) {
                String fieldValue = terms.term().text();
                this.facetCounts.initCount(fieldValue);
                if (terms.next()) continue;
                break;
            }
        }
        finally {
            terms.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RangeFacetCounter<N extends Number>
    extends FacetCounter {
        private final List<FacetRange<N>> ranges;

        RangeFacetCounter(RangeFacetRequest<N> request) {
            this.ranges = request.getFacetRangeList();
            for (FacetRange<N> range : this.ranges) {
                this.initCount(range.getRangeString());
            }
        }

        @Override
        void countValue(Object value) {
            for (FacetRange<Number> facetRange : this.ranges) {
                if (!facetRange.isInRange((Number)value)) continue;
                this.incrementCount(facetRange.getRangeString());
            }
        }
    }

    public static class SimpleFacetCounter
    extends FacetCounter {
        void countValue(Object value) {
            this.incrementCount((String)value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class FacetCounter {
        private Map<String, Integer> counts = CollectionHelper.newHashMap();

        Map<String, Integer> getCounts() {
            return this.counts;
        }

        void initCount(String value) {
            if (!this.counts.containsKey(value)) {
                this.counts.put(value, 0);
            }
        }

        void incrementCount(String value) {
            if (!this.counts.containsKey(value)) {
                this.counts.put(value, 1);
            } else {
                this.counts.put(value, this.counts.get(value) + 1);
            }
        }

        abstract void countValue(Object var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FacetComparator
    implements Comparator<Facet> {
        private final FacetSortOrder sortOder;

        public FacetComparator(FacetSortOrder sortOrder) {
            this.sortOder = sortOrder;
        }

        @Override
        public int compare(Facet facet1, Facet facet2) {
            if (FacetSortOrder.COUNT_ASC.equals((Object)this.sortOder)) {
                return facet1.getCount() - facet2.getCount();
            }
            if (FacetSortOrder.COUNT_DESC.equals((Object)this.sortOder)) {
                return facet2.getCount() - facet1.getCount();
            }
            return facet1.getValue().compareTo(facet2.getValue());
        }
    }
}

