/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldCacheContainer {
    private String[] stringCache;
    private byte[] byteCache;
    private double[] doubleCache;
    private float[] floatCache;
    private int[] intCache;
    private long[] longCache;
    private short[] shortCache;

    public void storeCacheArray(IndexReader reader, String fieldName, Class<?> cacheType) throws IOException {
        if (String.class.equals(cacheType)) {
            this.stringCache = FieldCache.DEFAULT.getStrings(reader, fieldName);
        } else if (Byte.class.equals(cacheType)) {
            this.byteCache = FieldCache.DEFAULT.getBytes(reader, fieldName);
        } else if (Double.class.equals(cacheType)) {
            this.doubleCache = FieldCache.DEFAULT.getDoubles(reader, fieldName);
        } else if (Float.class.equals(cacheType)) {
            this.floatCache = FieldCache.DEFAULT.getFloats(reader, fieldName);
        } else if (Integer.class.equals(cacheType)) {
            this.intCache = FieldCache.DEFAULT.getInts(reader, fieldName);
        } else if (Long.class.equals(cacheType)) {
            this.longCache = FieldCache.DEFAULT.getLongs(reader, fieldName);
        } else if (Short.class.equals(cacheType)) {
            this.shortCache = FieldCache.DEFAULT.getShorts(reader, fieldName);
        } else {
            throw new IllegalArgumentException("Unsupported cache type");
        }
    }

    public boolean containsCacheArray(Class<?> type) {
        if (String.class.equals(type)) {
            return this.stringCache != null;
        }
        if (Byte.class.equals(type)) {
            return this.byteCache != null;
        }
        if (Double.class.equals(type)) {
            return this.doubleCache != null;
        }
        if (Float.class.equals(type)) {
            return this.floatCache != null;
        }
        if (Integer.class.equals(type)) {
            return this.intCache != null;
        }
        if (Long.class.equals(type)) {
            return this.longCache != null;
        }
        if (Short.class.equals(type)) {
            return this.shortCache != null;
        }
        return false;
    }

    public Object getCacheValue(Class<?> type, int index) {
        if (String.class.equals(type)) {
            if (this.stringCache != null) {
                return this.stringCache[index];
            }
        } else if (Byte.class.equals(type)) {
            if (this.byteCache != null) {
                return this.byteCache[index];
            }
        } else if (Double.class.equals(type)) {
            if (this.doubleCache != null) {
                return this.doubleCache[index];
            }
        } else if (Float.class.equals(type)) {
            if (this.floatCache != null) {
                return Float.valueOf(this.floatCache[index]);
            }
        } else if (Integer.class.equals(type)) {
            if (this.intCache != null) {
                return this.intCache[index];
            }
        } else if (Long.class.equals(type)) {
            if (this.longCache != null) {
                return this.longCache[index];
            }
        } else if (Short.class.equals(type) && this.shortCache != null) {
            return this.shortCache[index];
        }
        return null;
    }
}

