/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.engine.impl;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.FieldSelectorResult;
import org.apache.lucene.document.MapFieldSelector;
import org.hibernate.search.engine.DocumentBuilderHelper;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.query.engine.impl.EntityInfoImpl;
import org.hibernate.search.query.engine.impl.IndexSearcherWithPayload;
import org.hibernate.search.query.engine.impl.QueryHits;
import org.hibernate.search.query.engine.spi.DocumentExtractor;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.hibernate.search.query.fieldcache.FieldCacheCollector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentExtractorImpl
implements DocumentExtractor {
    private static final Float FLOAT_ONE = Float.valueOf(1.0f);
    private final SearchFactoryImplementor searchFactoryImplementor;
    private final String[] projection;
    private final QueryHits queryHits;
    private final IndexSearcherWithPayload searcher;
    private FieldSelector fieldSelector;
    private boolean allowFieldSelection;
    private boolean needId;
    private final Map<String, Class> targetedClasses;
    private int firstIndex;
    private int maxIndex;
    private Object query;
    private final Class singleClassIfPossible;
    private final FieldCacheCollector<String> classTypeCollector;
    private final FieldCacheCollector idsCollector;

    public DocumentExtractorImpl(QueryHits queryHits, SearchFactoryImplementor searchFactoryImplementor, String[] projection, Set<String> idFieldNames, boolean allowFieldSelection, IndexSearcherWithPayload searcher, Object query, int firstIndex, int maxIndex, Set<Class<?>> classesAndSubclasses) {
        this.searchFactoryImplementor = searchFactoryImplementor;
        this.projection = projection != null ? (String[])projection.clone() : null;
        this.queryHits = queryHits;
        this.allowFieldSelection = allowFieldSelection;
        this.targetedClasses = new HashMap<String, Class>(classesAndSubclasses.size());
        for (Class<?> clazz : classesAndSubclasses) {
            this.targetedClasses.put(clazz.getName(), clazz);
        }
        this.singleClassIfPossible = classesAndSubclasses.size() == 1 ? classesAndSubclasses.iterator().next() : null;
        this.searcher = searcher;
        this.query = query;
        this.firstIndex = firstIndex;
        this.maxIndex = maxIndex;
        this.classTypeCollector = queryHits.getClassTypeCollector();
        this.idsCollector = queryHits.getIdsCollector();
        this.initFieldSelection(projection, idFieldNames);
    }

    private void initFieldSelection(String[] projection, Set<String> idFieldNames) {
        HashMap<String, FieldSelectorResult> fields;
        if (projection == null) {
            this.needId = true;
            fields = new HashMap<String, FieldSelectorResult>(2);
        } else {
            fields = new HashMap(projection.length + 2);
            for (String projectionName : projection) {
                if (projectionName == null) continue;
                if ("__HSearch_This".equals(projectionName)) {
                    this.needId = true;
                    continue;
                }
                if ("__HSearch_Document".equals(projectionName)) {
                    this.allowFieldSelection = false;
                    this.needId = true;
                    return;
                }
                if ("__HSearch_Score".equals(projectionName) || "__HSearch_Boost".equals(projectionName)) continue;
                if ("__HSearch_id".equals(projectionName)) {
                    this.needId = true;
                    continue;
                }
                if ("__HSearch_DocumentId".equals(projectionName) || "__HSearch_Explanation".equals(projectionName) || "_hibernate_class".equals(projectionName)) continue;
                fields.put(projectionName, FieldSelectorResult.LOAD);
            }
        }
        if (this.singleClassIfPossible == null && this.classTypeCollector == null) {
            fields.put("_hibernate_class", FieldSelectorResult.LOAD);
        }
        if (this.needId && this.idsCollector == null) {
            for (String idFieldName : idFieldNames) {
                fields.put(idFieldName, FieldSelectorResult.LOAD);
            }
        }
        if (fields.size() == 1) {
            String key = (String)fields.keySet().iterator().next();
            fields.put(key, FieldSelectorResult.LOAD_AND_BREAK);
        }
        if (fields.size() != 0) {
            this.fieldSelector = new MapFieldSelector(fields);
        }
    }

    private EntityInfo extractEntityInfo(int docId, Document document) {
        Class clazz = this.extractClass(docId, document);
        String idName = DocumentBuilderHelper.getDocumentIdName(this.searchFactoryImplementor, clazz);
        Serializable id = this.extractId(docId, document, clazz);
        Object[] projected = null;
        if (this.projection != null && this.projection.length > 0) {
            projected = DocumentBuilderHelper.getDocumentFields(this.searchFactoryImplementor, clazz, document, this.projection);
        }
        return new EntityInfoImpl(clazz, idName, id, projected);
    }

    private Serializable extractId(int docId, Document document, Class clazz) {
        if (!this.needId) {
            return null;
        }
        if (this.idsCollector != null) {
            return (Serializable)this.idsCollector.getValue(docId);
        }
        return DocumentBuilderHelper.getDocumentId(this.searchFactoryImplementor, clazz, document);
    }

    private Class extractClass(int docId, Document document) {
        if (this.singleClassIfPossible != null) {
            return this.singleClassIfPossible;
        }
        String className = this.classTypeCollector != null ? this.classTypeCollector.getValue(docId) : document.get("_hibernate_class");
        Class clazz = this.targetedClasses.get(className);
        if (clazz != null) {
            return clazz;
        }
        return DocumentBuilderHelper.getDocumentClass(className);
    }

    @Override
    public EntityInfo extract(int index) throws IOException {
        Document document;
        int docId = this.queryHits.docId(index);
        EntityInfo entityInfo = this.extractEntityInfo(docId, document = this.extractDocument(index));
        Object[] eip = entityInfo.getProjection();
        if (eip != null && eip.length > 0) {
            for (int x = 0; x < this.projection.length; ++x) {
                if ("__HSearch_Score".equals(this.projection[x])) {
                    eip[x] = Float.valueOf(this.queryHits.score(index));
                    continue;
                }
                if ("__HSearch_id".equals(this.projection[x])) {
                    eip[x] = entityInfo.getId();
                    continue;
                }
                if ("__HSearch_Document".equals(this.projection[x])) {
                    eip[x] = document;
                    continue;
                }
                if ("__HSearch_DocumentId".equals(this.projection[x])) {
                    eip[x] = docId;
                    continue;
                }
                if ("__HSearch_Boost".equals(this.projection[x])) {
                    eip[x] = FLOAT_ONE;
                    continue;
                }
                if ("__HSearch_Explanation".equals(this.projection[x])) {
                    eip[x] = this.queryHits.explain(index);
                    continue;
                }
                if ("_hibernate_class".equals(this.projection[x])) {
                    eip[x] = entityInfo.getClazz();
                    continue;
                }
                if (!"__HSearch_This".equals(this.projection[x])) continue;
                entityInfo.getIndexesOfThis().add(x);
            }
        }
        return entityInfo;
    }

    @Override
    public int getFirstIndex() {
        return this.firstIndex;
    }

    @Override
    public int getMaxIndex() {
        return this.maxIndex;
    }

    @Override
    public void close() {
        this.searcher.closeSearcher(this.query, this.searchFactoryImplementor);
    }

    private Document extractDocument(int index) throws IOException {
        if (this.allowFieldSelection) {
            if (this.fieldSelector == null) {
                return null;
            }
            return this.queryHits.doc(index, this.fieldSelector);
        }
        return this.queryHits.doc(index);
    }
}

