/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.spi;

import java.beans.Introspector;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.lucene.search.Similarity;
import org.hibernate.annotations.common.reflection.MetadataProvider;
import org.hibernate.annotations.common.reflection.MetadataProviderInjector;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.java.JavaReflectionManager;
import org.hibernate.annotations.common.util.StringHelper;
import org.hibernate.search.SearchException;
import org.hibernate.search.Version;
import org.hibernate.search.annotations.AnalyzerDef;
import org.hibernate.search.annotations.AnalyzerDefs;
import org.hibernate.search.annotations.Factory;
import org.hibernate.search.annotations.FullTextFilterDef;
import org.hibernate.search.annotations.FullTextFilterDefs;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Key;
import org.hibernate.search.backend.BackendQueueProcessorFactory;
import org.hibernate.search.backend.LuceneIndexingParameters;
import org.hibernate.search.backend.UpdatableBackendQueueProcessorFactory;
import org.hibernate.search.backend.WorkerFactory;
import org.hibernate.search.backend.configuration.ConfigurationParseHelper;
import org.hibernate.search.cfg.SearchConfiguration;
import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.engine.DocumentBuilderContainedEntity;
import org.hibernate.search.engine.DocumentBuilderIndexedEntity;
import org.hibernate.search.engine.EntityState;
import org.hibernate.search.engine.FilterDef;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.engine.ServiceManager;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.exception.impl.LogErrorHandler;
import org.hibernate.search.filter.FilterCachingStrategy;
import org.hibernate.search.filter.MRUFilterCachingStrategy;
import org.hibernate.search.filter.ShardSensitiveOnlyFilter;
import org.hibernate.search.impl.ConfigContext;
import org.hibernate.search.impl.ImmutableSearchFactory;
import org.hibernate.search.impl.IncrementalSearchConfiguration;
import org.hibernate.search.impl.MappingModelMetadataProvider;
import org.hibernate.search.impl.MutableSearchFactory;
import org.hibernate.search.impl.MutableSearchFactoryState;
import org.hibernate.search.impl.SearchMappingBuilder;
import org.hibernate.search.jmx.IndexControl;
import org.hibernate.search.jmx.JMXRegistrar;
import org.hibernate.search.reader.ReaderProviderFactory;
import org.hibernate.search.spi.SearchFactoryIntegrator;
import org.hibernate.search.spi.ServiceProvider;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.spi.WritableBuildContext;
import org.hibernate.search.spi.internals.DirectoryProviderData;
import org.hibernate.search.spi.internals.PolymorphicIndexHierarchy;
import org.hibernate.search.spi.internals.SearchFactoryState;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.store.DirectoryProviderFactory;
import org.hibernate.search.store.optimization.OptimizerStrategy;
import org.hibernate.search.util.ClassLoaderHelper;
import org.hibernate.search.util.LoggerFactory;
import org.hibernate.search.util.ReflectionHelper;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchFactoryBuilder {
    private static final Logger log;
    private SearchConfiguration cfg;
    private MutableSearchFactory rootFactory;
    private final List<Class<?>> classes = new ArrayList();
    private final MutableSearchFactoryState factoryState = new MutableSearchFactoryState();

    public SearchFactoryBuilder configuration(SearchConfiguration configuration) {
        this.cfg = configuration;
        return this;
    }

    public SearchFactoryBuilder currentFactory(SearchFactoryIntegrator factory) {
        this.rootFactory = (MutableSearchFactory)factory;
        return this;
    }

    public SearchFactoryBuilder addClass(Class<?> clazz) {
        this.classes.add(clazz);
        return this;
    }

    public SearchFactoryImplementor buildSearchFactory() {
        SearchFactoryImplementor searchFactoryImplementor;
        if (this.rootFactory == null) {
            if (this.classes.size() > 0) {
                throw new SearchException("Cannot add a class if the original SearchFactory is not passed");
            }
            searchFactoryImplementor = this.buildNewSearchFactory();
        } else {
            searchFactoryImplementor = this.buildIncrementalSearchFactory();
        }
        String enableJMX = this.factoryState.getConfigurationProperties().getProperty("hibernate.search.jmx_enabled");
        if ("true".equalsIgnoreCase(enableJMX)) {
            this.enableIndexControlBean(searchFactoryImplementor);
        }
        return searchFactoryImplementor;
    }

    private void enableIndexControlBean(SearchFactoryImplementor searchFactoryImplementor) {
        if (!searchFactoryImplementor.isJMXEnabled()) {
            return;
        }
        Properties configurationProperties = this.factoryState.getConfigurationProperties();
        if (StringHelper.isEmpty((String)configurationProperties.getProperty("hibernate.session_factory_name"))) {
            log.debug("In order to bind the IndexControlMBean the Hibernate SessionFactory has to be available via JNDI");
            return;
        }
        if (JMXRegistrar.isNameRegistered("org.hibernate.search.jmx:type=IndexControlMBean")) {
            JMXRegistrar.unRegisterMBean("org.hibernate.search.jmx:type=IndexControlMBean");
        }
        IndexControl indexCtrlBean = new IndexControl(configurationProperties);
        JMXRegistrar.registerMBean(indexCtrlBean, "org.hibernate.search.jmx:type=IndexControlMBean");
    }

    private SearchFactoryImplementor buildIncrementalSearchFactory() {
        this.removeClassesAlreadyManaged();
        if (this.classes.size() == 0) {
            return this.rootFactory;
        }
        this.factoryState.copyStateFromOldFactory(this.rootFactory);
        Properties configurationProperties = this.factoryState.getConfigurationProperties();
        BuildContext buildContext = new BuildContext();
        IncrementalSearchConfiguration cfg = new IncrementalSearchConfiguration(this.classes, configurationProperties);
        ReflectionManager reflectionManager = this.getReflectionManager(cfg);
        this.initDocumentBuilders(cfg, reflectionManager, buildContext);
        Map<Class<?>, DocumentBuilderIndexedEntity<?>> documentBuildersIndexedEntities = this.factoryState.getDocumentBuildersIndexedEntities();
        Set<Class<?>> indexedClasses = documentBuildersIndexedEntities.keySet();
        for (DocumentBuilderIndexedEntity<?> builder : documentBuildersIndexedEntities.values()) {
            builder.postInitialize(indexedClasses);
        }
        Map<Class<?>, DocumentBuilderContainedEntity<?>> documentBuildersContainedEntities = this.factoryState.getDocumentBuildersContainedEntities();
        for (DocumentBuilderContainedEntity<?> builder : documentBuildersContainedEntities.values()) {
            builder.postInitialize(indexedClasses);
        }
        this.fillSimilarityMapping();
        BackendQueueProcessorFactory backend = this.factoryState.getBackendQueueProcessorFactory();
        if (backend instanceof UpdatableBackendQueueProcessorFactory) {
            UpdatableBackendQueueProcessorFactory updatableBackend = (UpdatableBackendQueueProcessorFactory)backend;
            updatableBackend.updateDirectoryProviders(this.factoryState.getDirectoryProviderData().keySet(), buildContext);
        }
        ImmutableSearchFactory factory = new ImmutableSearchFactory(this.factoryState);
        this.rootFactory.setDelegate(factory);
        return this.rootFactory;
    }

    private void removeClassesAlreadyManaged() {
        HashSet remove = new HashSet();
        Map<Class<?>, DocumentBuilderContainedEntity<?>> containedEntities = this.rootFactory.getDocumentBuildersContainedEntities();
        Map<Class<?>, DocumentBuilderIndexedEntity<?>> indexedEntities = this.rootFactory.getDocumentBuildersIndexedEntities();
        for (Class<Object> entity : this.classes) {
            if (!indexedEntities.containsKey(entity) && !containedEntities.containsKey(entity)) continue;
            remove.add(entity);
        }
        for (Class<Object> entity : remove) {
            this.classes.remove(entity);
        }
    }

    private SearchFactoryImplementor buildNewSearchFactory() {
        this.createCleanFactoryState();
        ReflectionManager reflectionManager = this.getReflectionManager(this.cfg);
        BuildContext buildContext = new BuildContext();
        SearchMapping mapping = SearchMappingBuilder.getSearchMapping(this.cfg);
        if (mapping != null) {
            if (!(reflectionManager instanceof MetadataProviderInjector)) {
                throw new SearchException("Programmatic mapping model used but ReflectionManager does not implement " + MetadataProviderInjector.class.getName());
            }
            MetadataProviderInjector injector = (MetadataProviderInjector)reflectionManager;
            MetadataProvider original = injector.getMetadataProvider();
            injector.setMetadataProvider((MetadataProvider)new MappingModelMetadataProvider(original, mapping));
        }
        this.factoryState.setIndexingStrategy(SearchFactoryBuilder.defineIndexingStrategy(this.cfg));
        this.factoryState.setDirectoryProviderIndexingParams(new HashMap<DirectoryProvider, LuceneIndexingParameters>());
        this.initDocumentBuilders(this.cfg, reflectionManager, buildContext);
        Map<Class<?>, DocumentBuilderIndexedEntity<?>> documentBuildersIndexedEntities = this.factoryState.getDocumentBuildersIndexedEntities();
        Set<Class<?>> indexedClasses = documentBuildersIndexedEntities.keySet();
        for (DocumentBuilderIndexedEntity<?> builder : documentBuildersIndexedEntities.values()) {
            builder.postInitialize(indexedClasses);
        }
        Map<Class<?>, DocumentBuilderContainedEntity<?>> documentBuildersContainedEntities = this.factoryState.getDocumentBuildersContainedEntities();
        for (DocumentBuilderContainedEntity<?> builder : documentBuildersContainedEntities.values()) {
            builder.postInitialize(indexedClasses);
        }
        this.fillSimilarityMapping();
        this.factoryState.setWorker(WorkerFactory.createWorker(this.cfg, buildContext));
        this.factoryState.setReaderProvider(ReaderProviderFactory.createReaderProvider(this.cfg, buildContext));
        this.factoryState.setFilterCachingStrategy(SearchFactoryBuilder.buildFilterCachingStrategy(this.cfg.getProperties()));
        this.factoryState.setCacheBitResultsSize(ConfigurationParseHelper.getIntValue(this.cfg.getProperties(), "hibernate.search.filter.cache_docidresults.size", 5));
        ImmutableSearchFactory factory = new ImmutableSearchFactory(this.factoryState);
        this.rootFactory.setDelegate(factory);
        return this.rootFactory;
    }

    private void fillSimilarityMapping() {
        Map<Class<?>, DocumentBuilderIndexedEntity<?>> documentBuildersIndexedEntities = this.factoryState.getDocumentBuildersIndexedEntities();
        for (DirectoryProviderData directoryConfiguration : this.factoryState.getDirectoryProviderData().values()) {
            for (Class<?> indexedType : directoryConfiguration.getClasses()) {
                DocumentBuilderIndexedEntity<?> documentBuilder = documentBuildersIndexedEntities.get(indexedType);
                Similarity similarity = documentBuilder.getSimilarity();
                Similarity prevSimilarity = directoryConfiguration.getSimilarity();
                if (prevSimilarity != null && !prevSimilarity.getClass().equals(similarity.getClass())) {
                    throw new SearchException("Multiple entities are sharing the same index but are declaring an inconsistent Similarity. When overriding default Similarity make sure that all types sharing a same index declare the same Similarity implementation.");
                }
                directoryConfiguration.setSimilarity(similarity);
            }
        }
    }

    private static FilterCachingStrategy buildFilterCachingStrategy(Properties properties) {
        String impl = properties.getProperty("hibernate.search.filter.cache_strategy");
        FilterCachingStrategy filterCachingStrategy = StringHelper.isEmpty((String)impl) || "mru".equalsIgnoreCase(impl) ? new MRUFilterCachingStrategy() : ClassLoaderHelper.instanceFromName(FilterCachingStrategy.class, impl, ImmutableSearchFactory.class, "filterCachingStrategy");
        filterCachingStrategy.initialize(properties);
        return filterCachingStrategy;
    }

    private void createCleanFactoryState() {
        if (this.rootFactory == null) {
            this.rootFactory = new MutableSearchFactory();
            this.factoryState.setDocumentBuildersIndexedEntities(new HashMap());
            this.factoryState.setDocumentBuildersContainedEntities(new HashMap());
            this.factoryState.setDirectoryProviderData(new HashMap());
            this.factoryState.setFilterDefinitions(new HashMap<String, FilterDef>());
            this.factoryState.setIndexHierarchy(new PolymorphicIndexHierarchy());
            this.factoryState.setConfigurationProperties(this.cfg.getProperties());
            this.factoryState.setErrorHandler(SearchFactoryBuilder.createErrorHandler(this.factoryState.getConfigurationProperties()));
            this.factoryState.setServiceManager(new ServiceManager(this.cfg));
        }
    }

    private void initDocumentBuilders(SearchConfiguration cfg, ReflectionManager reflectionManager, BuildContext buildContext) {
        ConfigContext context = new ConfigContext(cfg);
        Iterator<Class<?>> iter = cfg.getClassMappings();
        DirectoryProviderFactory factory = new DirectoryProviderFactory();
        this.initProgrammaticAnalyzers(context, reflectionManager);
        this.initProgrammaticallyDefinedFilterDef(reflectionManager);
        PolymorphicIndexHierarchy indexingHierarchy = this.factoryState.getIndexHierarchy();
        Map<Class<?>, DocumentBuilderIndexedEntity<?>> documentBuildersIndexedEntities = this.factoryState.getDocumentBuildersIndexedEntities();
        Map<Class<?>, DocumentBuilderContainedEntity<?>> documentBuildersContainedEntities = this.factoryState.getDocumentBuildersContainedEntities();
        while (iter.hasNext()) {
            XClass mappedXClass;
            Class<?> mappedClass = iter.next();
            if (mappedClass == null || (mappedXClass = reflectionManager.toXClass(mappedClass)) == null) continue;
            if (mappedXClass.isAnnotationPresent(Indexed.class)) {
                if (mappedXClass.isAbstract()) {
                    log.warn("Abstract classes can never insert index documents. Remove @Indexed.");
                    continue;
                }
                DirectoryProviderFactory.DirectoryProviders providers = factory.createDirectoryProviders(mappedXClass, cfg, buildContext, reflectionManager);
                DocumentBuilderIndexedEntity documentBuilder = new DocumentBuilderIndexedEntity(mappedXClass, context, providers, reflectionManager);
                indexingHierarchy.addIndexedClass(mappedClass);
                documentBuildersIndexedEntities.put(mappedClass, documentBuilder);
            } else {
                DocumentBuilderContainedEntity documentBuilder = new DocumentBuilderContainedEntity(mappedXClass, context, reflectionManager);
                if (documentBuilder.getEntityState() != EntityState.NON_INDEXABLE) {
                    documentBuildersContainedEntities.put(mappedClass, documentBuilder);
                }
            }
            this.bindFilterDefs(mappedXClass);
        }
        this.factoryState.setAnalyzers(context.initLazyAnalyzers());
        factory.startDirectoryProviders();
    }

    private void bindFilterDefs(XClass mappedXClass) {
        FullTextFilterDefs defsAnn;
        FullTextFilterDef defAnn = (FullTextFilterDef)mappedXClass.getAnnotation(FullTextFilterDef.class);
        if (defAnn != null) {
            this.bindFilterDef(defAnn, mappedXClass);
        }
        if ((defsAnn = (FullTextFilterDefs)mappedXClass.getAnnotation(FullTextFilterDefs.class)) != null) {
            for (FullTextFilterDef def : defsAnn.value()) {
                this.bindFilterDef(def, mappedXClass);
            }
        }
    }

    private void bindFilterDef(FullTextFilterDef defAnn, XClass mappedXClass) {
        if (this.factoryState.getFilterDefinitions().containsKey(defAnn.name())) {
            throw new SearchException("Multiple definition of @FullTextFilterDef.name=" + defAnn.name() + ": " + mappedXClass.getName());
        }
        this.bindFullTextFilterDef(defAnn);
    }

    private void bindFullTextFilterDef(FullTextFilterDef defAnn) {
        FilterDef filterDef = new FilterDef(defAnn);
        Map<String, FilterDef> filterDefinition = this.factoryState.getFilterDefinitions();
        if (filterDef.getImpl().equals(ShardSensitiveOnlyFilter.class)) {
            filterDefinition.put(defAnn.name(), filterDef);
            return;
        }
        try {
            filterDef.getImpl().newInstance();
        }
        catch (IllegalAccessException e) {
            throw new SearchException("Unable to create Filter class: " + filterDef.getImpl().getName(), e);
        }
        catch (InstantiationException e) {
            throw new SearchException("Unable to create Filter class: " + filterDef.getImpl().getName(), e);
        }
        for (Method method : filterDef.getImpl().getMethods()) {
            String name;
            if (method.isAnnotationPresent(Factory.class)) {
                if (filterDef.getFactoryMethod() != null) {
                    throw new SearchException("Multiple @Factory methods found" + defAnn.name() + ": " + filterDef.getImpl().getName() + "." + method.getName());
                }
                ReflectionHelper.setAccessible(method);
                filterDef.setFactoryMethod(method);
            }
            if (method.isAnnotationPresent(Key.class)) {
                if (filterDef.getKeyMethod() != null) {
                    throw new SearchException("Multiple @Key methods found" + defAnn.name() + ": " + filterDef.getImpl().getName() + "." + method.getName());
                }
                ReflectionHelper.setAccessible(method);
                filterDef.setKeyMethod(method);
            }
            if (!(name = method.getName()).startsWith("set") || method.getParameterTypes().length != 1) continue;
            filterDef.addSetter(Introspector.decapitalize(name.substring(3)), method);
        }
        filterDefinition.put(defAnn.name(), filterDef);
    }

    private void initProgrammaticAnalyzers(ConfigContext context, ReflectionManager reflectionManager) {
        AnalyzerDef[] defs;
        Map defaults = reflectionManager.getDefaults();
        if (defaults != null && (defs = (AnalyzerDef[])defaults.get(AnalyzerDefs.class)) != null) {
            for (AnalyzerDef def : defs) {
                context.addGlobalAnalyzerDef(def);
            }
        }
    }

    private void initProgrammaticallyDefinedFilterDef(ReflectionManager reflectionManager) {
        Map defaults = reflectionManager.getDefaults();
        FullTextFilterDef[] filterDefs = (FullTextFilterDef[])defaults.get(FullTextFilterDefs.class);
        if (filterDefs != null && filterDefs.length != 0) {
            Map<String, FilterDef> filterDefinitions = this.factoryState.getFilterDefinitions();
            for (FullTextFilterDef defAnn : filterDefs) {
                if (filterDefinitions.containsKey(defAnn.name())) {
                    throw new SearchException("Multiple definition of @FullTextFilterDef.name=" + defAnn.name());
                }
                this.bindFullTextFilterDef(defAnn);
            }
        }
    }

    private static ErrorHandler createErrorHandler(Properties configuration) {
        String errorHandlerClassName = configuration.getProperty("hibernate.search.error_handler");
        if (StringHelper.isEmpty((String)errorHandlerClassName)) {
            return new LogErrorHandler();
        }
        if (errorHandlerClassName.trim().equals("log")) {
            return new LogErrorHandler();
        }
        return ClassLoaderHelper.instanceFromName(ErrorHandler.class, errorHandlerClassName, ImmutableSearchFactory.class, "Error Handler");
    }

    private ReflectionManager getReflectionManager(SearchConfiguration cfg) {
        ReflectionManager reflectionManager = cfg.getReflectionManager();
        return this.geReflectionManager(reflectionManager);
    }

    private ReflectionManager geReflectionManager(ReflectionManager reflectionManager) {
        if (reflectionManager == null) {
            reflectionManager = new JavaReflectionManager();
        }
        return reflectionManager;
    }

    private static String defineIndexingStrategy(SearchConfiguration cfg) {
        String indexingStrategy = cfg.getProperties().getProperty("hibernate.search.indexing_strategy", "event");
        if (!"event".equals(indexingStrategy) && !"manual".equals(indexingStrategy)) {
            throw new SearchException("hibernate.search.indexing_strategy unknown: " + indexingStrategy);
        }
        return indexingStrategy;
    }

    static {
        Version.touch();
        log = LoggerFactory.make();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BuildContext
    implements WritableBuildContext,
    WorkerBuildContext {
        private final SearchFactoryState factoryState;

        private BuildContext() {
            this.factoryState = SearchFactoryBuilder.this.factoryState;
        }

        @Override
        public void addOptimizerStrategy(DirectoryProvider<?> provider, OptimizerStrategy optimizerStrategy) {
            Map<DirectoryProvider<?>, DirectoryProviderData> dirProviderData = this.factoryState.getDirectoryProviderData();
            DirectoryProviderData data = dirProviderData.get(provider);
            if (data == null) {
                data = new DirectoryProviderData();
                dirProviderData.put(provider, data);
            }
            data.setOptimizerStrategy(optimizerStrategy);
        }

        @Override
        public void addIndexingParameters(DirectoryProvider<?> provider, LuceneIndexingParameters indexingParams) {
            this.factoryState.getDirectoryProviderIndexingParams().put(provider, indexingParams);
        }

        @Override
        public void addClassToDirectoryProvider(Class<?> entity, DirectoryProvider<?> directoryProvider, boolean exclusiveIndexUsage) {
            Map<DirectoryProvider<?>, DirectoryProviderData> dirProviderData = this.factoryState.getDirectoryProviderData();
            DirectoryProviderData data = dirProviderData.get(directoryProvider);
            if (data == null) {
                data = new DirectoryProviderData();
                dirProviderData.put(directoryProvider, data);
            }
            data.getClasses().add(entity);
            data.setExclusiveIndexUsage(exclusiveIndexUsage);
        }

        @Override
        public SearchFactoryImplementor getUninitializedSearchFactory() {
            return SearchFactoryBuilder.this.rootFactory;
        }

        @Override
        public String getIndexingStrategy() {
            return this.factoryState.getIndexingStrategy();
        }

        @Override
        public Set<DirectoryProvider<?>> getDirectoryProviders() {
            return this.factoryState.getDirectoryProviderData().keySet();
        }

        @Override
        public void setBackendQueueProcessorFactory(BackendQueueProcessorFactory backendQueueProcessorFactory) {
            this.factoryState.setBackendQueueProcessorFactory(backendQueueProcessorFactory);
        }

        @Override
        public OptimizerStrategy getOptimizerStrategy(DirectoryProvider<?> provider) {
            return this.factoryState.getDirectoryProviderData().get(provider).getOptimizerStrategy();
        }

        @Override
        public Set<Class<?>> getClassesInDirectoryProvider(DirectoryProvider<?> directoryProvider) {
            return Collections.unmodifiableSet(this.factoryState.getDirectoryProviderData().get(directoryProvider).getClasses());
        }

        @Override
        public LuceneIndexingParameters getIndexingParameters(DirectoryProvider<?> provider) {
            return this.factoryState.getDirectoryProviderIndexingParams().get(provider);
        }

        @Override
        public ReentrantLock getDirectoryProviderLock(DirectoryProvider<?> dp) {
            return this.factoryState.getDirectoryProviderData().get(dp).getDirLock();
        }

        @Override
        public <T> T requestService(Class<? extends ServiceProvider<T>> provider) {
            return this.factoryState.getServiceManager().requestService(provider);
        }

        @Override
        public void releaseService(Class<? extends ServiceProvider<?>> provider) {
            this.factoryState.getServiceManager().releaseService(provider);
        }

        @Override
        public Similarity getSimilarity(DirectoryProvider<?> provider) {
            Similarity similarity = this.factoryState.getDirectoryProviderData().get(provider).getSimilarity();
            if (similarity == null) {
                throw new SearchException("Assertion error: a similarity should be defined for each provider");
            }
            return similarity;
        }

        @Override
        public boolean isExclusiveIndexUsageEnabled(DirectoryProvider<?> provider) {
            return this.factoryState.getDirectoryProviderData().get(provider).isExclusiveIndexUsage();
        }

        @Override
        public ErrorHandler getErrorHandler() {
            return this.factoryState.getErrorHandler();
        }

        @Override
        public <T> DocumentBuilderIndexedEntity<T> getDocumentBuilderIndexedEntity(Class<T> entityType) {
            return this.factoryState.getDocumentBuildersIndexedEntities().get(entityType);
        }
    }
}

